package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHLJEnum implements AreaCodeEnumerable {
    CODE_230000("230000", "黑龙江省"),
    CODE_230100("230100", "黑龙江省哈尔滨市"),
    CODE_230101("230101", "黑龙江省哈尔滨市市辖区"),
    CODE_230102("230102", "黑龙江省哈尔滨市道里区"),
    CODE_230103("230103", "黑龙江省哈尔滨市南岗区"),
    CODE_230104("230104", "黑龙江省哈尔滨市道外区"),
    CODE_230105("230105", "黑龙江省哈尔滨市太平区"),
    CODE_230106("230106", "黑龙江省哈尔滨市香坊区"),
    CODE_230107("230107", "黑龙江省哈尔滨市动力区"),
    CODE_230108("230108", "黑龙江省哈尔滨市平房区"),
    CODE_230121("230121", "黑龙江省哈尔滨市呼兰县"),
    CODE_230123("230123", "黑龙江省哈尔滨市依兰县"),
    CODE_230124("230124", "黑龙江省哈尔滨市方正县"),
    CODE_230125("230125", "黑龙江省哈尔滨市宾县"),
    CODE_230126("230126", "黑龙江省哈尔滨市巴彦县"),
    CODE_230127("230127", "黑龙江省哈尔滨市木兰县"),
    CODE_230128("230128", "黑龙江省哈尔滨市通河县"),
    CODE_230129("230129", "黑龙江省哈尔滨市延寿县"),
    CODE_230181("230181", "黑龙江省哈尔滨市阿城市"),
    CODE_230182("230182", "黑龙江省哈尔滨市双城市"),
    CODE_230183("230183", "黑龙江省哈尔滨市尚志市"),
    CODE_230184("230184", "黑龙江省哈尔滨市五常市"),
    CODE_230200("230200", "黑龙江省齐齐哈尔市"),
    CODE_230201("230201", "黑龙江省齐齐哈尔市市辖区"),
    CODE_230202("230202", "黑龙江省齐齐哈尔市龙沙区"),
    CODE_230203("230203", "黑龙江省齐齐哈尔市建华区"),
    CODE_230204("230204", "黑龙江省齐齐哈尔市铁锋区"),
    CODE_230205("230205", "黑龙江省齐齐哈尔市昂昂溪区"),
    CODE_230206("230206", "黑龙江省齐齐哈尔市富拉尔基区"),
    CODE_230207("230207", "黑龙江省齐齐哈尔市碾子山区"),
    CODE_230208("230208", "黑龙江省齐齐哈尔市梅里斯达斡尔族区"),
    CODE_230221("230221", "黑龙江省齐齐哈尔市龙江县"),
    CODE_230223("230223", "黑龙江省齐齐哈尔市依安县"),
    CODE_230224("230224", "黑龙江省齐齐哈尔市泰来县"),
    CODE_230225("230225", "黑龙江省齐齐哈尔市甘南县"),
    CODE_230227("230227", "黑龙江省齐齐哈尔市富裕县"),
    CODE_230229("230229", "黑龙江省齐齐哈尔市克山县"),
    CODE_230230("230230", "黑龙江省齐齐哈尔市克东县"),
    CODE_230231("230231", "黑龙江省齐齐哈尔市拜泉县"),
    CODE_230281("230281", "黑龙江省齐齐哈尔市讷河市"),
    CODE_230300("230300", "黑龙江省鸡西市"),
    CODE_230301("230301", "黑龙江省鸡西市市辖区"),
    CODE_230302("230302", "黑龙江省鸡西市鸡冠区"),
    CODE_230303("230303", "黑龙江省鸡西市恒山区"),
    CODE_230304("230304", "黑龙江省鸡西市滴道区"),
    CODE_230305("230305", "黑龙江省鸡西市梨树区"),
    CODE_230306("230306", "黑龙江省鸡西市城子河区"),
    CODE_230307("230307", "黑龙江省鸡西市麻山区"),
    CODE_230321("230321", "黑龙江省鸡西市鸡东县"),
    CODE_230381("230381", "黑龙江省鸡西市虎林市"),
    CODE_230382("230382", "黑龙江省鸡西市密山市"),
    CODE_230400("230400", "黑龙江省鹤岗市"),
    CODE_230401("230401", "黑龙江省鹤岗市市辖区"),
    CODE_230402("230402", "黑龙江省鹤岗市向阳区"),
    CODE_230403("230403", "黑龙江省鹤岗市工农区"),
    CODE_230404("230404", "黑龙江省鹤岗市南山区"),
    CODE_230405("230405", "黑龙江省鹤岗市兴安区"),
    CODE_230406("230406", "黑龙江省鹤岗市东山区"),
    CODE_230407("230407", "黑龙江省鹤岗市兴山区"),
    CODE_230421("230421", "黑龙江省鹤岗市萝北县"),
    CODE_230422("230422", "黑龙江省鹤岗市绥滨县"),
    CODE_230500("230500", "黑龙江省双鸭山市"),
    CODE_230501("230501", "黑龙江省双鸭山市市辖区"),
    CODE_230502("230502", "黑龙江省双鸭山市尖山区"),
    CODE_230503("230503", "黑龙江省双鸭山市岭东区"),
    CODE_230505("230505", "黑龙江省双鸭山市四方台区"),
    CODE_230506("230506", "黑龙江省双鸭山市宝山区"),
    CODE_230521("230521", "黑龙江省双鸭山市集贤县"),
    CODE_230522("230522", "黑龙江省双鸭山市友谊县"),
    CODE_230523("230523", "黑龙江省双鸭山市宝清县"),
    CODE_230524("230524", "黑龙江省双鸭山市饶河县"),
    CODE_230600("230600", "黑龙江省大庆市"),
    CODE_230601("230601", "黑龙江省大庆市市辖区"),
    CODE_230602("230602", "黑龙江省大庆市萨尔图区"),
    CODE_230603("230603", "黑龙江省大庆市龙凤区"),
    CODE_230604("230604", "黑龙江省大庆市让胡路区"),
    CODE_230605("230605", "黑龙江省大庆市红岗区"),
    CODE_230606("230606", "黑龙江省大庆市大同区"),
    CODE_230621("230621", "黑龙江省大庆市肇州县"),
    CODE_230622("230622", "黑龙江省大庆市肇源县"),
    CODE_230623("230623", "黑龙江省大庆市林甸县"),
    CODE_230624("230624", "黑龙江省大庆市杜尔伯特蒙古族自治县"),
    CODE_230700("230700", "黑龙江省伊春市"),
    CODE_230701("230701", "黑龙江省伊春市市辖区"),
    CODE_230702("230702", "黑龙江省伊春市伊春区"),
    CODE_230703("230703", "黑龙江省伊春市南岔区"),
    CODE_230704("230704", "黑龙江省伊春市友好区"),
    CODE_230705("230705", "黑龙江省伊春市西林区"),
    CODE_230706("230706", "黑龙江省伊春市翠峦区"),
    CODE_230707("230707", "黑龙江省伊春市新青区"),
    CODE_230708("230708", "黑龙江省伊春市美溪区"),
    CODE_230709("230709", "黑龙江省伊春市金山屯区"),
    CODE_230710("230710", "黑龙江省伊春市五营区"),
    CODE_230711("230711", "黑龙江省伊春市乌马河区"),
    CODE_230712("230712", "黑龙江省伊春市汤旺河区"),
    CODE_230713("230713", "黑龙江省伊春市带岭区"),
    CODE_230714("230714", "黑龙江省伊春市乌伊岭区"),
    CODE_230715("230715", "黑龙江省伊春市红星区"),
    CODE_230716("230716", "黑龙江省伊春市上甘岭区"),
    CODE_230722("230722", "黑龙江省伊春市嘉荫县"),
    CODE_230781("230781", "黑龙江省伊春市铁力市"),
    CODE_230800("230800", "黑龙江省佳木斯市"),
    CODE_230801("230801", "黑龙江省佳木斯市市辖区"),
    CODE_230802("230802", "黑龙江省佳木斯市永红区"),
    CODE_230803("230803", "黑龙江省佳木斯市向阳区"),
    CODE_230804("230804", "黑龙江省佳木斯市前进区"),
    CODE_230805("230805", "黑龙江省佳木斯市东风区"),
    CODE_230811("230811", "黑龙江省佳木斯市郊区"),
    CODE_230822("230822", "黑龙江省佳木斯市桦南县"),
    CODE_230826("230826", "黑龙江省佳木斯市桦川县"),
    CODE_230828("230828", "黑龙江省佳木斯市汤原县"),
    CODE_230833("230833", "黑龙江省佳木斯市抚远县"),
    CODE_230881("230881", "黑龙江省佳木斯市同江市"),
    CODE_230882("230882", "黑龙江省佳木斯市富锦市"),
    CODE_230900("230900", "黑龙江省七台河市"),
    CODE_230901("230901", "黑龙江省七台河市市辖区"),
    CODE_230902("230902", "黑龙江省七台河市新兴区"),
    CODE_230903("230903", "黑龙江省七台河市桃山区"),
    CODE_230904("230904", "黑龙江省七台河市茄子河区"),
    CODE_230921("230921", "黑龙江省七台河市勃利县"),
    CODE_231000("231000", "黑龙江省牡丹江市"),
    CODE_231001("231001", "黑龙江省牡丹江市市辖区"),
    CODE_231002("231002", "黑龙江省牡丹江市东安区"),
    CODE_231003("231003", "黑龙江省牡丹江市阳明区"),
    CODE_231004("231004", "黑龙江省牡丹江市爱民区"),
    CODE_231005("231005", "黑龙江省牡丹江市西安区"),
    CODE_231024("231024", "黑龙江省牡丹江市东宁县"),
    CODE_231025("231025", "黑龙江省牡丹江市林口县"),
    CODE_231081("231081", "黑龙江省牡丹江市绥芬河市"),
    CODE_231083("231083", "黑龙江省牡丹江市海林市"),
    CODE_231084("231084", "黑龙江省牡丹江市宁安市"),
    CODE_231085("231085", "黑龙江省牡丹江市穆棱市"),
    CODE_231100("231100", "黑龙江省黑河市"),
    CODE_231101("231101", "黑龙江省黑河市市辖区"),
    CODE_231102("231102", "黑龙江省黑河市爱辉区"),
    CODE_231121("231121", "黑龙江省黑河市嫩江县"),
    CODE_231123("231123", "黑龙江省黑河市逊克县"),
    CODE_231124("231124", "黑龙江省黑河市孙吴县"),
    CODE_231181("231181", "黑龙江省黑河市北安市"),
    CODE_231182("231182", "黑龙江省黑河市五大连池市"),
    CODE_232300("232300", "黑龙江省绥化地区"),
    CODE_232301("232301", "黑龙江省绥化地区绥化市"),
    CODE_232302("232302", "黑龙江省绥化地区安达市"),
    CODE_232303("232303", "黑龙江省绥化地区肇东市"),
    CODE_232304("232304", "黑龙江省绥化地区海伦市"),
    CODE_232324("232324", "黑龙江省绥化地区望奎县"),
    CODE_232325("232325", "黑龙江省绥化地区兰西县"),
    CODE_232326("232326", "黑龙江省绥化地区青冈县"),
    CODE_232330("232330", "黑龙江省绥化地区庆安县"),
    CODE_232331("232331", "黑龙江省绥化地区明水县"),
    CODE_232332("232332", "黑龙江省绥化地区绥棱县"),
    CODE_232700("232700", "黑龙江省大兴安岭地区"),
    CODE_232721("232721", "黑龙江省大兴安岭地区呼玛县"),
    CODE_232722("232722", "黑龙江省大兴安岭地区塔河县"),
    CODE_232723("232723", "黑龙江省大兴安岭地区漠河县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHLJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
