package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeNXEnum implements AreaCodeEnumerable {
    CODE_640000("640000", "宁夏回族自治区"),
    CODE_640100("640100", "宁夏回族自治区银川市"),
    CODE_640101("640101", "宁夏回族自治区银川市市辖区"),
    CODE_640102("640102", "宁夏回族自治区银川市城区"),
    CODE_640103("640103", "宁夏回族自治区银川市新城区"),
    CODE_640111("640111", "宁夏回族自治区银川市郊区"),
    CODE_640121("640121", "宁夏回族自治区银川市永宁县"),
    CODE_640122("640122", "宁夏回族自治区银川市贺兰县"),
    CODE_640200("640200", "宁夏回族自治区石嘴山市"),
    CODE_640201("640201", "宁夏回族自治区石嘴山市市辖区"),
    CODE_640202("640202", "宁夏回族自治区石嘴山市大武口区"),
    CODE_640203("640203", "宁夏回族自治区石嘴山市石嘴山区"),
    CODE_640204("640204", "宁夏回族自治区石嘴山市石炭井区"),
    CODE_640221("640221", "宁夏回族自治区石嘴山市平罗县"),
    CODE_640222("640222", "宁夏回族自治区石嘴山市陶乐县"),
    CODE_640223("640223", "宁夏回族自治区石嘴山市惠农县"),
    CODE_640300("640300", "宁夏回族自治区吴忠市"),
    CODE_640301("640301", "宁夏回族自治区吴忠市市辖区"),
    CODE_640302("640302", "宁夏回族自治区吴忠市利通区"),
    CODE_640321("640321", "宁夏回族自治区吴忠市中卫县"),
    CODE_640322("640322", "宁夏回族自治区吴忠市中宁县"),
    CODE_640323("640323", "宁夏回族自治区吴忠市盐池县"),
    CODE_640324("640324", "宁夏回族自治区吴忠市同心县"),
    CODE_640381("640381", "宁夏回族自治区吴忠市青铜峡市"),
    CODE_640382("640382", "宁夏回族自治区吴忠市灵武市"),
    CODE_642200("642200", "宁夏回族自治区固原地区"),
    CODE_642221("642221", "宁夏回族自治区固原地区固原县"),
    CODE_642222("642222", "宁夏回族自治区固原地区海原县"),
    CODE_642223("642223", "宁夏回族自治区固原地区西吉县"),
    CODE_642224("642224", "宁夏回族自治区固原地区隆德县"),
    CODE_642225("642225", "宁夏回族自治区固原地区泾源县"),
    CODE_642226("642226", "宁夏回族自治区固原地区彭阳县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeNXEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
