package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeSCEnum implements AreaCodeEnumerable {
    CODE_510000("510000", "四川省"),
    CODE_510100("510100", "四川省成都市"),
    CODE_510101("510101", "四川省成都市市辖区"),
    CODE_510104("510104", "四川省成都市锦江区"),
    CODE_510105("510105", "四川省成都市青羊区"),
    CODE_510106("510106", "四川省成都市金牛区"),
    CODE_510107("510107", "四川省成都市武侯区"),
    CODE_510108("510108", "四川省成都市成华区"),
    CODE_510112("510112", "四川省成都市龙泉驿区"),
    CODE_510113("510113", "四川省成都市青白江区"),
    CODE_510121("510121", "四川省成都市金堂县"),
    CODE_510122("510122", "四川省成都市双流县"),
    CODE_510123("510123", "四川省成都市温江县"),
    CODE_510124("510124", "四川省成都市郫县"),
    CODE_510125("510125", "四川省成都市新都县"),
    CODE_510129("510129", "四川省成都市大邑县"),
    CODE_510131("510131", "四川省成都市蒲江县"),
    CODE_510132("510132", "四川省成都市新津县"),
    CODE_510181("510181", "四川省成都市都江堰市"),
    CODE_510182("510182", "四川省成都市彭州市"),
    CODE_510183("510183", "四川省成都市邛崃市"),
    CODE_510184("510184", "四川省成都市崇州市"),
    CODE_510300("510300", "四川省自贡市"),
    CODE_510301("510301", "四川省自贡市市辖区"),
    CODE_510302("510302", "四川省自贡市自流井区"),
    CODE_510303("510303", "四川省自贡市贡井区"),
    CODE_510304("510304", "四川省自贡市大安区"),
    CODE_510311("510311", "四川省自贡市沿滩区"),
    CODE_510321("510321", "四川省自贡市荣县"),
    CODE_510322("510322", "四川省自贡市富顺县"),
    CODE_510400("510400", "四川省攀枝花市"),
    CODE_510401("510401", "四川省攀枝花市市辖区"),
    CODE_510402("510402", "四川省攀枝花市东区"),
    CODE_510403("510403", "四川省攀枝花市西区"),
    CODE_510411("510411", "四川省攀枝花市仁和区"),
    CODE_510421("510421", "四川省攀枝花市米易县"),
    CODE_510422("510422", "四川省攀枝花市盐边县"),
    CODE_510500("510500", "四川省泸州市"),
    CODE_510501("510501", "四川省泸州市市辖区"),
    CODE_510502("510502", "四川省泸州市江阳区"),
    CODE_510503("510503", "四川省泸州市纳溪区"),
    CODE_510504("510504", "四川省泸州市龙马潭区"),
    CODE_510521("510521", "四川省泸州市泸县"),
    CODE_510522("510522", "四川省泸州市合江县"),
    CODE_510524("510524", "四川省泸州市叙永县"),
    CODE_510525("510525", "四川省泸州市古蔺县"),
    CODE_510600("510600", "四川省德阳市"),
    CODE_510601("510601", "四川省德阳市市辖区"),
    CODE_510603("510603", "四川省德阳市旌阳区"),
    CODE_510623("510623", "四川省德阳市中江县"),
    CODE_510626("510626", "四川省德阳市罗江县"),
    CODE_510681("510681", "四川省德阳市广汉市"),
    CODE_510682("510682", "四川省德阳市什邡市"),
    CODE_510683("510683", "四川省德阳市绵竹市"),
    CODE_510700("510700", "四川省绵阳市"),
    CODE_510701("510701", "四川省绵阳市市辖区"),
    CODE_510703("510703", "四川省绵阳市涪城区"),
    CODE_510704("510704", "四川省绵阳市游仙区"),
    CODE_510722("510722", "四川省绵阳市三台县"),
    CODE_510723("510723", "四川省绵阳市盐亭县"),
    CODE_510724("510724", "四川省绵阳市安县"),
    CODE_510725("510725", "四川省绵阳市梓潼县"),
    CODE_510726("510726", "四川省绵阳市北川县"),
    CODE_510727("510727", "四川省绵阳市平武县"),
    CODE_510781("510781", "四川省绵阳市江油市"),
    CODE_510800("510800", "四川省广元市"),
    CODE_510801("510801", "四川省广元市市辖区"),
    CODE_510802("510802", "四川省广元市市中区"),
    CODE_510811("510811", "四川省广元市元坝区"),
    CODE_510812("510812", "四川省广元市朝天区"),
    CODE_510821("510821", "四川省广元市旺苍县"),
    CODE_510822("510822", "四川省广元市青川县"),
    CODE_510823("510823", "四川省广元市剑阁县"),
    CODE_510824("510824", "四川省广元市苍溪县"),
    CODE_510900("510900", "四川省遂宁市"),
    CODE_510901("510901", "四川省遂宁市市辖区"),
    CODE_510902("510902", "四川省遂宁市市中区"),
    CODE_510921("510921", "四川省遂宁市蓬溪县"),
    CODE_510922("510922", "四川省遂宁市射洪县"),
    CODE_510923("510923", "四川省遂宁市大英县"),
    CODE_511000("511000", "四川省内江市"),
    CODE_511001("511001", "四川省内江市市辖区"),
    CODE_511002("511002", "四川省内江市市中区"),
    CODE_511011("511011", "四川省内江市东兴区"),
    CODE_511024("511024", "四川省内江市威远县"),
    CODE_511025("511025", "四川省内江市资中县"),
    CODE_511028("511028", "四川省内江市隆昌县"),
    CODE_511100("511100", "四川省乐山市"),
    CODE_511101("511101", "四川省乐山市市辖区"),
    CODE_511102("511102", "四川省乐山市市中区"),
    CODE_511111("511111", "四川省乐山市沙湾区"),
    CODE_511112("511112", "四川省乐山市五通桥区"),
    CODE_511113("511113", "四川省乐山市金口河区"),
    CODE_511123("511123", "四川省乐山市犍为县"),
    CODE_511124("511124", "四川省乐山市井研县"),
    CODE_511126("511126", "四川省乐山市夹江县"),
    CODE_511129("511129", "四川省乐山市沐川县"),
    CODE_511132("511132", "四川省乐山市峨边彝族自治县"),
    CODE_511133("511133", "四川省乐山市马边彝族自治县"),
    CODE_511181("511181", "四川省乐山市峨眉山市"),
    CODE_511300("511300", "四川省南充市"),
    CODE_511301("511301", "四川省南充市市辖区"),
    CODE_511302("511302", "四川省南充市顺庆区"),
    CODE_511303("511303", "四川省南充市高坪区"),
    CODE_511304("511304", "四川省南充市嘉陵区"),
    CODE_511321("511321", "四川省南充市南部县"),
    CODE_511322("511322", "四川省南充市营山县"),
    CODE_511323("511323", "四川省南充市蓬安县"),
    CODE_511324("511324", "四川省南充市仪陇县"),
    CODE_511325("511325", "四川省南充市西充县"),
    CODE_511381("511381", "四川省南充市阆中市"),
    CODE_511500("511500", "四川省宜宾市"),
    CODE_511501("511501", "四川省宜宾市市辖区"),
    CODE_511502("511502", "四川省宜宾市翠屏区"),
    CODE_511521("511521", "四川省宜宾市宜宾县"),
    CODE_511522("511522", "四川省宜宾市南溪县"),
    CODE_511523("511523", "四川省宜宾市江安县"),
    CODE_511524("511524", "四川省宜宾市长宁县"),
    CODE_511525("511525", "四川省宜宾市高县"),
    CODE_511526("511526", "四川省宜宾市珙县"),
    CODE_511527("511527", "四川省宜宾市筠连县"),
    CODE_511528("511528", "四川省宜宾市兴文县"),
    CODE_511529("511529", "四川省宜宾市屏山县"),
    CODE_511600("511600", "四川省广安市"),
    CODE_511601("511601", "四川省广安市市辖区"),
    CODE_511602("511602", "四川省广安市广安区"),
    CODE_511621("511621", "四川省广安市岳池县"),
    CODE_511622("511622", "四川省广安市武胜县"),
    CODE_511623("511623", "四川省广安市邻水县"),
    CODE_511681("511681", "四川省广安市华蓥市"),
    CODE_513000("513000", "四川省达川地区"),
    CODE_513001("513001", "四川省达川地区达川市"),
    CODE_513002("513002", "四川省达川地区万源市"),
    CODE_513021("513021", "四川省达川地区达县"),
    CODE_513022("513022", "四川省达川地区宣汉县"),
    CODE_513023("513023", "四川省达川地区开江县"),
    CODE_513029("513029", "四川省达川地区大竹县"),
    CODE_513030("513030", "四川省达川地区渠县"),
    CODE_513100("513100", "四川省雅安地区"),
    CODE_513101("513101", "四川省雅安地区雅安市"),
    CODE_513122("513122", "四川省雅安地区名山县"),
    CODE_513123("513123", "四川省雅安地区荥经县"),
    CODE_513124("513124", "四川省雅安地区汉源县"),
    CODE_513125("513125", "四川省雅安地区石棉县"),
    CODE_513126("513126", "四川省雅安地区天全县"),
    CODE_513127("513127", "四川省雅安地区芦山县"),
    CODE_513128("513128", "四川省雅安地区宝兴县"),
    CODE_513200("513200", "四川省阿坝藏族羌族自治州"),
    CODE_513221("513221", "四川省阿坝藏族羌族自治州汶川县"),
    CODE_513222("513222", "四川省阿坝藏族羌族自治州理县"),
    CODE_513223("513223", "四川省阿坝藏族羌族自治州茂县"),
    CODE_513224("513224", "四川省阿坝藏族羌族自治州松潘县"),
    CODE_513225("513225", "四川省阿坝藏族羌族自治州九寨沟县"),
    CODE_513226("513226", "四川省阿坝藏族羌族自治州金川县"),
    CODE_513227("513227", "四川省阿坝藏族羌族自治州小金县"),
    CODE_513228("513228", "四川省阿坝藏族羌族自治州黑水县"),
    CODE_513229("513229", "四川省阿坝藏族羌族自治州马尔康县"),
    CODE_513230("513230", "四川省阿坝藏族羌族自治州壤塘县"),
    CODE_513231("513231", "四川省阿坝藏族羌族自治州阿坝县"),
    CODE_513232("513232", "四川省阿坝藏族羌族自治州若尔盖县"),
    CODE_513233("513233", "四川省阿坝藏族羌族自治州红原县"),
    CODE_513300("513300", "四川省甘孜藏族自治州"),
    CODE_513321("513321", "四川省甘孜藏族自治州康定县"),
    CODE_513322("513322", "四川省甘孜藏族自治州泸定县"),
    CODE_513323("513323", "四川省甘孜藏族自治州丹巴县"),
    CODE_513324("513324", "四川省甘孜藏族自治州九龙县"),
    CODE_513325("513325", "四川省甘孜藏族自治州雅江县"),
    CODE_513326("513326", "四川省甘孜藏族自治州道孚县"),
    CODE_513327("513327", "四川省甘孜藏族自治州炉霍县"),
    CODE_513328("513328", "四川省甘孜藏族自治州甘孜县"),
    CODE_513329("513329", "四川省甘孜藏族自治州新龙县"),
    CODE_513330("513330", "四川省甘孜藏族自治州德格县"),
    CODE_513331("513331", "四川省甘孜藏族自治州白玉县"),
    CODE_513332("513332", "四川省甘孜藏族自治州石渠县"),
    CODE_513333("513333", "四川省甘孜藏族自治州色达县"),
    CODE_513334("513334", "四川省甘孜藏族自治州理塘县"),
    CODE_513335("513335", "四川省甘孜藏族自治州巴塘县"),
    CODE_513336("513336", "四川省甘孜藏族自治州乡城县"),
    CODE_513337("513337", "四川省甘孜藏族自治州稻城县"),
    CODE_513338("513338", "四川省甘孜藏族自治州得荣县"),
    CODE_513400("513400", "四川省凉山彝族自治州"),
    CODE_513401("513401", "四川省凉山彝族自治州西昌市"),
    CODE_513422("513422", "四川省凉山彝族自治州木里藏族自治县"),
    CODE_513423("513423", "四川省凉山彝族自治州盐源县"),
    CODE_513424("513424", "四川省凉山彝族自治州德昌县"),
    CODE_513425("513425", "四川省凉山彝族自治州会理县"),
    CODE_513426("513426", "四川省凉山彝族自治州会东县"),
    CODE_513427("513427", "四川省凉山彝族自治州宁南县"),
    CODE_513428("513428", "四川省凉山彝族自治州普格县"),
    CODE_513429("513429", "四川省凉山彝族自治州布拖县"),
    CODE_513430("513430", "四川省凉山彝族自治州金阳县"),
    CODE_513431("513431", "四川省凉山彝族自治州昭觉县"),
    CODE_513432("513432", "四川省凉山彝族自治州喜德县"),
    CODE_513433("513433", "四川省凉山彝族自治州冕宁县"),
    CODE_513434("513434", "四川省凉山彝族自治州越西县"),
    CODE_513435("513435", "四川省凉山彝族自治州甘洛县"),
    CODE_513436("513436", "四川省凉山彝族自治州美姑县"),
    CODE_513437("513437", "四川省凉山彝族自治州雷波县"),
    CODE_513700("513700", "四川省巴中地区"),
    CODE_513701("513701", "四川省巴中地区巴中市"),
    CODE_513721("513721", "四川省巴中地区通江县"),
    CODE_513722("513722", "四川省巴中地区南江县"),
    CODE_513723("513723", "四川省巴中地区平昌县"),
    CODE_513800("513800", "四川省眉山地区"),
    CODE_513821("513821", "四川省眉山地区眉山县"),
    CODE_513822("513822", "四川省眉山地区仁寿县"),
    CODE_513823("513823", "四川省眉山地区彭山县"),
    CODE_513824("513824", "四川省眉山地区洪雅县"),
    CODE_513825("513825", "四川省眉山地区丹棱县"),
    CODE_513826("513826", "四川省眉山地区青神县"),
    CODE_513900("513900", "四川省眉山地区资阳地区"),
    CODE_513901("513901", "四川省眉山地区资阳市"),
    CODE_513902("513902", "四川省眉山地区简阳市"),
    CODE_513921("513921", "四川省眉山地区安岳县"),
    CODE_513922("513922", "四川省眉山地区乐至县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeSCEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
