package com.qiho.center.api.enums.bizlog;

/**
 * tb_qiho_biz_log表中biz_status字段枚举
 * <p>
 * Created by sunchangji on 2017/11/23.
 */
public enum BizLogStatusEnum {

    TO_BEGIN(0, "待开始"),
    COMPLETE(1, "完成"),
    FAIL(2, "失败");

    BizLogStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static BizLogStatusEnum getByCode(int code) {
        for (BizLogStatusEnum enumVal : BizLogStatusEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    private int code;

    private String desc;

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
