package com.qiho.center.api.enums.blacklist;

/**
 * 黑名单使用类型枚举
 *
 * @author chensong
 * @create 2018-04-24 11:13
 **/
public enum BlackListUseTypeEnum {

    ALL(1,"ALL","全部商家"),

    PART(2,"PART","部分商家")
    ;

    private int num;

    private String code;

    private String desc;

    private BlackListUseTypeEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static BlackListUseTypeEnum getByNum(int num){
        for (BlackListUseTypeEnum value : BlackListUseTypeEnum.values()) {
            if (value.getNum() == num){
                return value;
            }
        }
        return null;
    }
}
