package com.qiho.center.api.enums.embed;

/**埋点结果枚举
 * @author chensong
 * @create 2018-02-27 16:26
 **/
public enum EmbedResultEnum {

    /** 发送成功 */
    SUCCESS("SUCCESS", "发送成功", 1),

    /** 未发送 */
    UNSEND("UNSEND"," 未发送", 2),

    /** 发送失败 */
    FAILED("FAILED", "发送失败", 0);



    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 数字 */
    private Integer num;

    private EmbedResultEnum(String code, String desc, Integer num){
        this.code = code;
        this.desc = desc;
        this.num = num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getNum() {
        return num;
    }

    public static EmbedResultEnum getByNum(int num){
        for (EmbedResultEnum value : EmbedResultEnum.values()) {
            if (num == value.getNum().intValue()) {
                return value;
            }
        }
        return null;
    }

    public static EmbedResultEnum getByNum(Integer num){
        return getByNum(num.intValue());
    }
}
