package com.qiho.center.api.enums.strategy;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2021/1/28 3:34 下午
 */
@Getter
@AllArgsConstructor
public enum MobileCardTypeEnum {

    YD(1, "移动卡"),
    LT(2, "联通卡"),
    DX(3, "电信卡"),
    DEFAULT(-1,"默认");

    private Integer type;

    private String name;

    private static Map<String, Integer> cardNameMap = new HashMap<>();
    static {
        cardNameMap.put(YD.getName(), YD.getType());
        cardNameMap.put(LT.getName(), LT.getType());
        cardNameMap.put(DX.getName(), DX.getType());

    }

    public static boolean isLtAndDx(Integer type) {
        return LT.getType().equals(type) || DX.getType().equals(type);
    }

    public static Integer getTypeByName(String name) {
        Integer type = cardNameMap.get(name);
        return type == null ? DEFAULT.getType() : type;
    }
}
