package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.ItemSimpleDto;

import java.util.List;

/**
 * Created by Administrator on 2017/9/20 0020.
 */
@AdvancedFeignClient
public interface RemoteDetailRecommendService {

    /**
     * 根据商品id获取推荐位
     * @param itemId
     * @return
     */
    DubboResult<List<DetailRecommendDto>> findByItemId(Long itemId);


    /**
     * 根据商品ID
     * 查询推荐位信息
     * 如果不存在则创建
     * @param itemId
     * @return
     */
    DubboResult<List<DetailRecommendDto>> queryDetailRecommend(Long itemId);


    /**
     * 保存商品
     * 推荐位信息
     * @param dtos
     * @return
     */
    DubboResult<Boolean> saveDetailRecommend(List<DetailRecommendDto> dtos);


    /**
     * 查询商品信息
     * @param itemId
     * @return
     */
    DubboResult<ItemSimpleDto> queryItemDetail(Long itemId);


}
