package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.MainItemDto;
import com.qiho.center.api.dto.PagenationDto;

import java.util.List;

/**
 * Created by weny.cai on 2017/8/29.
 */
@AdvancedFeignClient
public interface RemoteMainItemService {

    /**
     * 添加主推商品
     * @param mainItemDto
     * @return
     */
    DubboResult<Integer> addMainItem(MainItemDto mainItemDto);

    /**
     * 删除主推商品
     * @param ids
     * @return
     */
    DubboResult<Integer> deleteMainItems(List<Long> ids);

    /**
     * 修改主推商品
     * @param mainItemDto
     * @return
     */
    DubboResult<Integer> editMainItem(MainItemDto mainItemDto);

    /**
     * 查询主推商品详情
     * @param id
     * @return
     */
    DubboResult<MainItemDto> queryMainItem(Long id);

    /**
     * 查询主推商品列表
     * @return
     */
    DubboResult<PagenationDto<MainItemDto>> queryMainItems();

    /**
     * 查询有效的主推商品列表
     * 用于Web
     * @return
     */
    DubboResult<PagenationDto<MainItemDto>> queryVaildList();

    /**
     * 拖动排序
     * @param mainIitemId
     * @param originPayload
     * @param newPayload
     * @return
     */
    DubboResult<Boolean> sortMainItem(Long mainIitemId,Integer originPayload,Integer newPayload);
}
