package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;

import java.util.List;

/**
 * Created by weny.cai on 2017/8/31.
 */
@AdvancedFeignClient
public interface RemoteTabService {

    /**
     * 增加Tab
     * @param tabDto
     * @return
     */
    DubboResult<Integer> add(TabDto tabDto);

    /**
     * 删除Tab
     * @param ids
     * @return
     */
    DubboResult<Integer> deleteList(List<Long> ids);

    /**
     * 更新Tab
     * @param tabDto
     * @return
     */
    DubboResult<Integer> update(TabDto tabDto);

    /**
     * 查询Tab 详情
     * @param id
     * @return
     */
    DubboResult<TabDto> queryDetail(Long id);

    /**
     * 查询Tab列表
     * @return
     */
    DubboResult<PagenationDto<TabDto>> queryList();

    /**
     * 查询启用Tab列表
     * @return
     */
    DubboResult<List<TabDto>> queryOnList();

    /**
     * 拖动排序
     * @param sortId
     * @param startPayload
     * @param endPayload
     * @return
     */
    DubboResult<Boolean> sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload);

}
