package com.qiho.center.api.remoteservice.homepage;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.enums.TabItemStatusEnum;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;

import java.util.List;

/**
 * Created by qianjue on 2017/8/29.
 */
@AdvancedFeignClient
public interface RemoteTabItemService {

	/**
	 * 批量新增tab商品
	 * @param list
	 * @return
	 */
	DubboResult<Integer> saveTabItemList(List<TabItemParams> list);

	/**
	 * 批量删除item
	 * @param idList
	 * @return
	 */
	DubboResult<Integer> deleteTabItemByIdList(List<Long> idList);

	/**
	 * 批量置顶/取消置顶商品
	 * @param idList
	 * @param top
	 * @return
	 */
	DubboResult<Integer> updateTabItemTopPayloadByList(List<Long> idList,Long tabId,Boolean top);

	/**
	 * 查询商品列表
	 * @param params
	 * @return
	 */
	DubboResult<List<TabItemDto>> findTabItemList(TabItemQueryParam params);



	DubboResult<List<ItemDto>> queryTabItemIndex(TabItemQueryParam params);


	/**
	 * 批量启用/禁用tab下的商品
	 *
	 * @param itemIds 商品ID列表
	 * @param status  更新后的商品状态，{@link TabItemStatusEnum}
	 * @return DubboResult
	 * @author zhanglihui
	 */
	DubboResult<Void> updateStatus(List<Long> itemIds, Long tabId, Integer status, Long gmtModifier);

	/**
	 * 根据商品id集合查找指定tab栏目下的商品
	 *
	 * @param itemIdList 商品ID列表
	 * @param tabId  tab栏ID
	 * @return
	 */
	List<TabItemDto> queryTabItemByTabIdAndItemIds(List<Long> itemIdList, Long tabId);

	/**
	 * 保存tab商品
	 * @param params
	 * @return
	 */
	DubboResult<Integer> saveTabItem(TabItemParams params);

	/**
	 * 商品启用/禁用状态初始化
	 * @return
	 */
	DubboResult<Integer> initTabItemStatus();
}
