package com.qiho.center.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.message.MessageCheckedDto;
import com.qiho.center.api.dto.message.MessageNotifyDto;
import com.qiho.center.api.params.message.MessageCheckedPagingParams;


/**
 * 消息远程调用接口(非管理后台)
 * @author: wangjin
 * @create 2018-07-02 14:51
 **/
@AdvancedFeignClient
public interface RemoteMessageService {

    /**
     * 未读消息数量
     * @param merchantId
     * @return
     */
    int countCheckedMessage(Long merchantId);

    /**
     * 消息列表
     * @param params
     * @return
     */
    PagenationDto<MessageCheckedDto> findCheckedMessages(MessageCheckedPagingParams params);

    /**
     * 查看消息详情
     * @param id
     * @param merchantId
     * @return
     */
    MessageNotifyDto findMessageById(Long id,Long merchantId);

    /**
     * 弹框消息
     * @param merchantId
     * @return
     */
    MessageNotifyDto findMessageDescription(Long merchantId);
}
