package com.qiho.center.api.remoteservice.region;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.region.BaiqiRegionDto;
import com.qiho.center.api.dto.region.BaiqiRegionRelationDto;

import java.util.List;

/**
 * 中国省市区乡镇
 * Author: zhanghuifeng
 * Date:   2018/1/16 10:13
 */
@AdvancedFeignClient
public interface RemoteBaiqiRegionService {

    /**
     * 根据上级区域ID查询所有区域
     * @param parentId 上级区域ID
     * @return 集合
     */
    List<BaiqiRegionDto> find(Long parentId);


    /**
     * 修复区域编码
     * @param startId 开始ID
     * @param endId   结束ID
     * @return boolean
     */
    Boolean updateAreaNum(int startId, int endId);

    /**
     * 更新区域编码
     * @param regionName  区域名称
     * @param areaNum     行政区划代码
     * @return boolean
     */
    Boolean updateAreaNumByRegionName(String regionName, int areaNum);

    /**
     * 获取行政区划代码为空的区域信息，限制1000条
     * @param regionLevel  区域级别
     * @return 集合
     */
    List<BaiqiRegionDto> findNullAreaNumRegion(Integer regionLevel);

    /**
     * 根据区域代码获取区域信息
     * @param areaNum 行政区划代码
     * @return 区域信息
     */
    BaiqiRegionRelationDto findRegionByAreaNum(Integer areaNum);

    /**
     * 根据名称和等级查询区域信息
     *
     * @param regionName  区域名称
     * @param regionLevel 区域等级
     * @return 区域信息
     */
    BaiqiRegionDto findByNameAndLevel(String regionName, int regionLevel);
}
