/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.frontfile;

import com.qiho.center.api.enums.component.ComponentUsageTypeEnum;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FrontFileEnum {
    COMPONENT_PAGE_MAIN_JS("component.page.main.js", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "\u5546\u54c1\u8be6\u60c5\u9875mainJs"),
    COMPONENT_PAGE_VENDOR_JS("component.page.vendor.js", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "\u5546\u54c1\u8be6\u60c5\u9875vendorJs"),
    COMPONENT_PAGE_BASE_CSS("component.page.base.css", ComponentUsageTypeEnum.ITEM_DEATIL.getNum(), "\u5546\u54c1\u8be6\u60c5\u9875baseCss"),
    COMPONENT_PAGE_BASE_COLLECTION_CSS("component.page.base.collection.css", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "\u96c6\u5408\u9875baseCss"),
    COMPONENT_PAGE_COLLECTION_MAIN_JS("component.page.collection.main.js", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "\u96c6\u5408\u9875mainJs"),
    COMPONENT_PAGE_COLLECTION_VENDOR_JS("component.page.collection.vendor.js", ComponentUsageTypeEnum.COLLECTION_PAGE.getNum(), "\u96c6\u5408\u9875vendorJs");

    private String fileKey;
    private int type;
    private String fileDesc;

    private FrontFileEnum(String fileKey, int type, String fileDesc) {
        this.fileKey = fileKey;
        this.type = type;
        this.fileDesc = fileDesc;
    }

    public static boolean isFileKeyLegal(String fileKey) {
        if (fileKey == null || fileKey.isEmpty()) {
            return false;
        }
        return Stream.of(FrontFileEnum.values()).map(FrontFileEnum::getFileKey).anyMatch(tempFileKey -> Objects.equals(tempFileKey, fileKey));
    }

    public static List<String> getFileKeysByType(int type) {
        return Stream.of(FrontFileEnum.values()).filter(temp -> type == temp.getType()).map(FrontFileEnum::getFileKey).collect(Collectors.toList());
    }

    public static List<String> getAllFileKeys() {
        return Stream.of(FrontFileEnum.values()).map(FrontFileEnum::getFileKey).collect(Collectors.toList());
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public int getType() {
        return this.type;
    }

    public String getFileDesc() {
        return this.fileDesc;
    }
}

