/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SHA1 {
    public static Logger LOGGER = LoggerFactory.getLogger(SHA1.class);

    public static String sha1(String str) {
        if (str == null) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(str.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                String shaHex = Integer.toHexString(b & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("sha1 error str:{}", (Object)str, (Object)e);
            return "";
        }
    }
}

