/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncAckDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.biz.runnable.LogisticsOrderSignRunnable;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams;
import com.qiho.center.common.params.YTOLogisticProcessParams;
import com.qiho.center.common.util.ERPClientUtil;
import com.qiho.center.common.util.JaxbUtil;
import com.qiho.center.common.util.YTOClientUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class LogisticsOrderBo
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsOrderBo.class);
    private static final String QUERY_ERP_LOGISTICS_SYNC_LIMIT = "100";
    private static final String IS_PART_SYNC_ABLE = "0";
    private static final String YTO_FAILED_RETURN = "<success>false</success>";
    private ApplicationContext context;
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Resource
    private ExecutorService executorService;

    public void erpLogisticsSyncQuery() {
        while (true) {
            HashMap params = Maps.newHashMap();
            params.put("shop_no", ERPClientUtil.getShopNo());
            params.put("limit", QUERY_ERP_LOGISTICS_SYNC_LIMIT);
            params.put("is_part_sync_able", IS_PART_SYNC_ABLE);
            String logisticsJson = null;
            try {
                logisticsJson = ERPClientUtil.execute((String)ERPClientUtil.getLogisticsSyncUrl(), (Map)params);
            }
            catch (Exception e) {
                LOG.error("ERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                break;
            }
            List<ErpLogisticsSyncDto> list = this.getLogisticsOrderDtoList(logisticsJson);
            if (CollectionUtils.isEmpty(list)) {
                LOG.info("ERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5b8c\u6210\u3002\u65e0\u5f85\u540c\u6b65\u7269\u6d41\u4fe1\u606f");
                break;
            }
            List<ErpLogisticsSyncAckDto> listReurn = this.logisticsOrderService.createLogisticsOrderBatch(list);
            if (CollectionUtils.isEmpty(listReurn)) continue;
            HashMap returnParams = Maps.newHashMap();
            returnParams.put("logistics_list", JSON.toJSONString(listReurn));
            try {
                ERPClientUtil.execute((String)ERPClientUtil.getLogisticsAckUrl(), (Map)returnParams);
            }
            catch (Exception e) {
                LOG.error("\u8fd4\u56deERP\u7cfb\u7edf\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5904\u7406\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public List<ErpLogisticsSyncDto> getLogisticsOrderDtoList(String logisticsJson) {
        ArrayList list = Lists.newArrayList();
        try {
            if (StringUtils.isBlank((String)logisticsJson)) {
                return ListUtils.EMPTY_LIST;
            }
            JSONObject json = JSON.parseObject((String)logisticsJson);
            String code = json.getString("code");
            if (!StringUtils.equals((String)code, (String)ErpErrorCodeReturnEnum.SUCCESS.getCode())) {
                return ListUtils.EMPTY_LIST;
            }
            JSONArray temp = JSON.parseArray((String)json.get((Object)"trades").toString());
            if (temp.size() <= 0) {
                return ListUtils.EMPTY_LIST;
            }
            for (int j = 0; j < temp.size(); ++j) {
                JSONObject t = temp.getJSONObject(j);
                ErpLogisticsSyncDto queryLogisticsReturnDto = (ErpLogisticsSyncDto)JSON.toJavaObject((JSON)t, ErpLogisticsSyncDto.class);
                queryLogisticsReturnDto.setLogisticsCode(ExpressCompanyEnum.YTO.getCode());
                list.add(queryLogisticsReturnDto);
            }
        }
        catch (Exception e) {
            return ListUtils.EMPTY_LIST;
        }
        return list;
    }

    public List<LogisticsProcessDto> queryYTOLogisticsProcessByPostId(String postId) {
        if (StringUtils.isBlank((String)postId)) {
            return ListUtils.EMPTY_LIST;
        }
        QueryYTOLogisticProcessParams queryXml = new QueryYTOLogisticProcessParams(new QueryYTOLogisticProcessParams.Result(new QueryYTOLogisticProcessParams.Result.WaybillCode(postId)));
        List list = Lists.newArrayList();
        try {
            YTOLogisticProcessParams returnLogistics;
            String logisticsString = YTOClientUtil.execute((String)YTOClientUtil.getQueryLogisticsUrl(), (Object)queryXml);
            if (StringUtils.isNotBlank((String)logisticsString) && !StringUtils.contains((String)logisticsString, (String)YTO_FAILED_RETURN) && (returnLogistics = (YTOLogisticProcessParams)JaxbUtil.converyToJavaBean((String)logisticsString, YTOLogisticProcessParams.class)) != null) {
                List logisticDetail = returnLogistics.getResult().getLogisticDetail();
                list = BeanUtils.copyList((List)logisticDetail, LogisticsProcessDto.class);
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Collections.reverse(list);
            }
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u5706\u901a\u5feb\u9012\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38");
            return ListUtils.EMPTY_LIST;
        }
        return list;
    }

    public Integer batchSignOrder(String progressKey, List<LogisticsOrderDto> paramList) {
        LogisticsOrderSignRunnable runnable = (LogisticsOrderSignRunnable)this.context.getBean(LogisticsOrderSignRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        this.executorService.submit(runnable);
        return enableCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

