/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import java.lang.reflect.Field;
import java.util.Calendar;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public class RepeatPlaceOrderAction
extends ShotOrderAbstractAction {
    @Resource
    private OrderSnapshotService orderSnapshotService;

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) throws Exception {
        Field[] fields;
        String threshold = strategyRuleDto.getThreshold();
        String valuteVal = BaseHandler.getValuteVal(orderSnapshotDto, strategyRuleDto);
        if (StringUtils.isBlank((CharSequence)valuteVal)) {
            return ResultBase.rightReturn((Object)Boolean.FALSE);
        }
        String[] valuteFieldNameArr = strategyRuleDto.getFieldName().split("-");
        String valuteFieldName = valuteFieldNameArr[valuteFieldNameArr.length - 1];
        OrderPageParams pageParams = new OrderPageParams();
        for (Field field : fields = pageParams.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (!fieldName.equals(valuteFieldName)) continue;
            field.set(pageParams, valuteVal);
            break;
        }
        this.getStartAndEndTime(pageParams);
        Integer countOrder = this.orderSnapshotService.findAllPageCount(pageParams);
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(threshold, (Object)countOrder);
    }

    private OrderPageParams getStartAndEndTime(OrderPageParams orderPageParams) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 24);
        orderPageParams.setStartTime(calendar.getTime());
        calendar.set(11, calendar.get(11) + 25);
        orderPageParams.setEndTime(calendar.getTime());
        return orderPageParams;
    }
}

