/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.chain;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.ProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteHandler
implements BaseHandler {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private BaseHandler baseHandler;

    @Override
    public ResultBase<Boolean> handleRequest(ProcessContext context) throws Exception {
        StrategyRuleDto strategyRuleDto = context.getStrategyRuleDto();
        ShotOrderFieldEnum shotOrderFieldEnum = ShotOrderFieldEnum.fromVal((String)strategyRuleDto.getFieldName());
        if (null == shotOrderFieldEnum) {
            return ResultBase.errorReturn((String)("\u7b56\u7565\u914d\u7f6e\u6709\u8bef,\u9700\u8981\u6821\u9a8c\u7684\u5b57\u6bb5\u4fe1\u606f\u914d\u7f6e\u9519\u8bef fieldName=" + strategyRuleDto.getFieldName()));
        }
        if (shotOrderFieldEnum.getCode() > 100) {
            return this.baseHandler.handleRequest(context);
        }
        return this.valateOrder(context);
    }

    private ResultBase<Boolean> valateOrder(ProcessContext context) throws Exception {
        OrderSnapshotDto orderSnapshotDto = context.getOrderSnapshotDto();
        StrategyRuleDto strategyRuleDto = context.getStrategyRuleDto();
        String valuteVal = BaseHandler.getValuteVal(orderSnapshotDto, strategyRuleDto);
        String thresholdVal = strategyRuleDto.getThreshold();
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(thresholdVal, (Object)valuteVal);
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}

