/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.service.order.OrderStrategyService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShotOrderEngine
implements BaseEngine<OrderSnapshotDto> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public Map<String, BaseEngine> strategyTask;
    @Resource
    private OrderStrategyService orderStrategyService;
    private BaseHandler baseHandler;

    @Override
    public OrderSnapshotDto process(OrderSnapshotDto valuteData) {
        if (null == valuteData) {
            return valuteData;
        }
        OrderStrategyParams params = new OrderStrategyParams();
        params.setStrategyType(Integer.valueOf(StrategyType.SHOT_ORDER.getCode()));
        try {
            List orderStrategyDtos = this.orderStrategyService.findStrategyByQuery(params, null, null).getList();
            if (CollectionUtils.isEmpty((Collection)orderStrategyDtos)) {
                return valuteData;
            }
            for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
                BaseEngine baseEngine;
                Boolean flag = Boolean.TRUE;
                ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
                if (!resultBase.hasSuccessValue()) {
                    this.logger.warn(resultBase.getErrorMsg());
                    continue;
                }
                List strategyRuleDtos = (List)resultBase.getValue();
                ProcessContext processContext = null;
                for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                    processContext = ProcessFaceory.createProcessContext(valuteData, strategyRuleDto, orderStrategyDto);
                    ResultBase<Boolean> checkResult = this.baseHandler.handleRequest(processContext);
                    if (checkResult.hasSuccessValue()) {
                        flag = flag != false && (Boolean)checkResult.getValue() != false;
                        continue;
                    }
                    flag = Boolean.FALSE;
                    this.logger.warn("\u672c\u6761\u7b56\u7565\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
                    break;
                }
                if (!flag.booleanValue() || null == this.strategyTask || null == (baseEngine = this.strategyTask.get(orderStrategyDto.getHandlerName()))) continue;
                baseEngine.process(processContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7b56\u7565\u8fc7\u6ee4\u94fe\u8def\u5931\u8d25 msg={} data={}", (Object)e.getLocalizedMessage(), (Object)valuteData.toString());
        }
        return valuteData;
    }

    private ResultBase<List<StrategyRuleDto>> validateorderStrategyDto(OrderStrategyDto orderStrategyDto) {
        ResultBase resultBase = new ResultBase();
        if (StringUtils.isBlank((CharSequence)orderStrategyDto.getRulevalue())) {
            return resultBase.setErrorReturn("\u7b56\u7565\u4e3a\u7a7a,\u4e0d\u6821\u9a8c");
        }
        List strategyRuleDtos = JSONObject.parseArray((String)orderStrategyDto.getRulevalue(), StrategyRuleDto.class);
        if (CollectionUtils.isEmpty((Collection)strategyRuleDtos)) {
            return resultBase.setErrorReturn("\u6b64\u7b56\u7565\u7684\u7b56\u7565\u89c4\u5219\u503c\u4e3a\u7a7a,\u4e0d\u6821\u9a8c strategyName=" + orderStrategyDto.getStrategyName());
        }
        return resultBase.setRightReturn((Object)strategyRuleDtos);
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public Map<String, BaseEngine> getStrategyTask() {
        return this.strategyTask;
    }

    public void setStrategyTask(Map<String, BaseEngine> strategyTask) {
        this.strategyTask = strategyTask;
    }
}

