/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.util.AppLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErpAutoDeliveryJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOG = LoggerFactory.getLogger(ErpAutoDeliveryJob.class);
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Resource
    private ExecutorService executorService;
    private static final int AUTO_DELIVERY_LIMIT = 1000;
    private static final int MAX_ACTIVITY_COUNT = 20;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn((Logger)LOG, (String)"################ \u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u3010ErpAutoDeliveryJob\u3011 ################");
        int threadCount = ((ThreadPoolExecutorWrapper)this.executorService).getActiveCount();
        if (threadCount >= 20) {
            AppLogUtil.warn((Logger)LOG, (String)"################ \u5f53\u524d\u6d3b\u52a8\u7ebf\u7a0b\u6570\uff1a{}\uff0c\u8fbe\u5230\u9608\u503c{}\uff0c\u5b9a\u65f6\u4efb\u52a1\u6682\u7f13\u6267\u884c ################", (Object[])new Object[]{threadCount, 20});
            return;
        }
        List erpList = this.qihoErpOrderDAO.findAutoDeliveryLimit(1000);
        if (CollectionUtils.isEmpty((Collection)erpList)) {
            return;
        }
        for (QihoErpOrderEntity erpOrder : erpList) {
            this.erpOrderBo.autoDelivery(erpOrder);
        }
    }
}

