/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import com.google.common.collect.Maps;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.util.FormDataConvertUtil;
import com.qiho.center.api.util.MD5Facade;
import com.qiho.center.api.util.NowPayAppUtil;
import com.qiho.center.api.util.SignCheckUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class NowPayProcessor
extends PayChannelProcessor
implements InitializingBean {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FRONT_NOTIFY_URL = "http://dev-www.qiho99.com/order/success?orderId=";
    @Resource
    private OrderService orderService;
    @Resource
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Resource
    private FundOrderService fundOrderService;

    @Override
    public String payExecute(String orderId) {
        try {
            Map<String, String> dataMap = this.packageParamToMap(orderId);
            String parmaStr = FormDataConvertUtil.postFormLinkReportWithURLEncode(dataMap);
            String httpResultStr = HttpClientUtil.postData((String)NowPayAppUtil.getNowpayUrl(), (String)parmaStr);
            Map resultMap = FormDataConvertUtil.parseFormDataPatternReportWithDecode((String)httpResultStr);
            if (null == resultMap) {
                throw new QihoException("\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            boolean isValidSignature = SignCheckUtil.signCheck((Map)resultMap, (Boolean)Boolean.FALSE, (String)NowPayAppUtil.getAppKey());
            if (isValidSignature) {
                if (((String)resultMap.get("responseCode")).equalsIgnoreCase("A001")) {
                    return (String)resultMap.get("tn");
                }
                AppLogUtil.warn((Logger)this.logger, (String)"\u7533\u8bf7\u4ed8\u6b3e\u5931\u8d25 msg={}", (Object[])new Object[]{resultMap.get("responseMsg")});
            } else {
                AppLogUtil.warn((Logger)this.logger, (String)"\u9a8c\u7b7e\u5931\u8d25 orderId={}", (Object[])new Object[]{orderId});
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u73b0\u5728\u652f\u4ed8\u5f02\u5e38 msg={}", (Object[])new Object[]{e.getMessage()});
        }
        return "";
    }

    @Override
    public void refund(String orderId, String fundId, Integer refundAmt) {
        try {
            Map<String, String> dataMap = this.buildRefundParam(orderId, fundId, refundAmt);
            String parmaStr = FormDataConvertUtil.postFormLinkReportWithURLEncode(dataMap);
            String httpResultStr = HttpClientUtil.postData((String)NowPayAppUtil.getRefundUrl(), (String)parmaStr);
            Map resultMap = FormDataConvertUtil.parseFormDataPatternReportWithDecode((String)httpResultStr);
            if (null == resultMap) {
                throw new QihoException("\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            boolean isValidSignature = SignCheckUtil.signCheck((Map)resultMap, (Boolean)Boolean.TRUE, (String)NowPayAppUtil.getAppKey());
            FundOrderDto dto = this.fundOrderService.findByFundId(fundId);
            if (isValidSignature) {
                String transStatus = (String)resultMap.get("tradeStatus");
                String responseCode = (String)resultMap.get("responseCode");
                dto.setOutSeqNo((String)resultMap.get("nowPayOrderNo"));
                if ("A001".equals(transStatus) && "R000".equals(responseCode)) {
                    dto.setFundStatus(FundStatusEnum.SUCCESS.getCode());
                } else if ("A002".equals(transStatus)) {
                    dto.setFundStatus(FundStatusEnum.FAILED.getCode());
                    AppLogUtil.warn((Logger)this.logger, (String)"\u53d1\u9001\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25 orderId={} fundId={} reefundAmt={} responseMsg={}", (Object[])new Object[]{orderId, fundId, refundAmt, resultMap.get("responseMsg")});
                }
                this.fundOrderService.update(dto);
            } else {
                AppLogUtil.warn((Logger)this.logger, (String)"\u9a8c\u7b7e\u5931\u8d25 orderId={} fundId={} reefundAmt={}", (Object[])new Object[]{orderId, fundId, refundAmt});
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u8bf7\u6c42\u9000\u6b3e\u5f02\u5e38 msg={}", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public RefundResult refundQuery(String orderId, String fundId) {
        RefundResult refundResult = new RefundResult();
        try {
            Map<String, String> dataMap = this.buildRefundQueryParam(fundId);
            String parmaStr = FormDataConvertUtil.postFormLinkReportWithURLEncode(dataMap);
            String httpResultStr = HttpClientUtil.postData((String)NowPayAppUtil.getRefundUrl(), (String)parmaStr);
            Map resultMap = FormDataConvertUtil.parseFormDataPatternReportWithDecode((String)httpResultStr);
            if (null == resultMap) {
                throw new QihoException("\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            boolean isValidSignature = SignCheckUtil.signCheck((Map)resultMap, (Boolean)Boolean.TRUE, (String)NowPayAppUtil.getAppKey());
            String transStatus = (String)resultMap.get("tradeStatus");
            String responseCode = (String)resultMap.get("responseCode");
            if (isValidSignature && "R000".equals(responseCode) && "A001".equals(transStatus)) {
                refundResult.setFundId((String)resultMap.get("mhtRefundNo"));
                refundResult.setOrderId((String)resultMap.get("mhtOrderNo"));
                refundResult.setRefundAmt(Integer.valueOf((String)resultMap.get("amount")));
                refundResult.setIsSuccess(Boolean.TRUE);
                refundResult.setRefundReason((String)resultMap.get("reason"));
                refundResult.setOutTradeNo((String)resultMap.get("nowPayOrderNo"));
            } else {
                refundResult.setIsSuccess(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u8bf7\u6c42\u9000\u6b3e\u5f02\u5e38 msg={}", (Object[])new Object[]{e.getMessage()});
        }
        return refundResult;
    }

    @Override
    public boolean verify(Map<String, String> params) {
        String signature = params.remove("signature");
        return MD5Facade.validateFormDataParamMD5(params, (String)NowPayAppUtil.getAppKey(), (String)signature);
    }

    private Map<String, String> buildRefundParam(String orderId, String fundId, Integer refundAmt) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("funcode", "R001");
        dataMap.put("appId", NowPayAppUtil.getAppId());
        dataMap.put("mhtOrderNo", orderId);
        dataMap.put("mhtRefundNo", fundId);
        dataMap.put("reason", "\u8ba2\u5355\u8d85\u65f6");
        dataMap.put("mhtCharset", "UTF-8");
        dataMap.put("amount", refundAmt.toString());
        String mhtSignature = MD5Facade.getFormDataParamMD5(dataMap, (String)NowPayAppUtil.getAppKey(), (String)"UTF-8");
        dataMap.put("signType", "MD5");
        dataMap.put("mhtSignature", mhtSignature);
        return dataMap;
    }

    private Map<String, String> buildRefundQueryParam(String fundId) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("funcode", "Q001");
        dataMap.put("mhtRefundNo", fundId);
        dataMap.put("mhtCharset", "UTF-8");
        dataMap.put("appId", NowPayAppUtil.getAppId());
        String mhtSignature = MD5Facade.getFormDataParamMD5(dataMap, (String)NowPayAppUtil.getAppKey(), (String)"UTF-8");
        dataMap.put("signType", "MD5");
        dataMap.put("mhtSignature", mhtSignature);
        return dataMap;
    }

    private Map<String, String> packageParamToMap(String orderId) {
        List<FundOrderDto> resultFund = this.fundOrderService.findByOrderId(orderId);
        OrderDto orderDto = this.orderService.findByOrderId(orderId);
        if (null == orderDto) {
            throw new QihoException("\u901a\u8fc7\u8ba2\u5355id\u67e5\u8be2\u8ba2\u5355 || \u4ed8\u6b3e\u8ba2\u5355\u5f02\u5e38");
        }
        FundOrderDto fundOrderDto = resultFund.get(0);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("appId", NowPayAppUtil.getAppId());
        dataMap.put("deviceType", "0601");
        dataMap.put("funcode", "WP001");
        dataMap.put("version", "1.0.0");
        dataMap.put("mhtCurrencyType", "156");
        dataMap.put("mhtOrderType", "01");
        dataMap.put("mhtCharset", "UTF-8");
        dataMap.put("payChannelType", "13");
        dataMap.put("mhtSignType", "MD5");
        dataMap.put("outputType", "2");
        dataMap.put("mhtOrderNo", orderDto.getOrderId());
        dataMap.put("mhtOrderName", orderDto.getOrderItem().getItemName());
        dataMap.put("mhtOrderAmt", fundOrderDto.getAmt().toString());
        dataMap.put("mhtOrderDetail", fundOrderDto.getFundId());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String mhtOrderStartTime = dateFormat.format(new Date());
        dataMap.put("mhtOrderStartTime", mhtOrderStartTime);
        dataMap.put("notifyUrl", NowPayAppUtil.getNotifyUrl());
        dataMap.put("frontNotifyUrl", FRONT_NOTIFY_URL + orderId);
        String mhtSignature = MD5Facade.getFormDataParamMD5(dataMap, (String)NowPayAppUtil.getAppKey(), (String)"UTF-8");
        dataMap.put("mhtSignature", mhtSignature);
        return dataMap;
    }

    @Override
    public PayDto queryPayResult(String orderId) {
        PayDto payResult = new PayDto();
        HashMap dataMap = Maps.newHashMap();
        OrderDto orderResult = this.orderService.findByOrderId(orderId);
        if (null == orderResult) {
            throw new QihoException("\u53d1\u8d77\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25,\u8ba2\u5355id\u6709\u8bef");
        }
        dataMap.put("appId", NowPayAppUtil.getAppId());
        dataMap.put("funcode", "MQ002");
        dataMap.put("mhtOrderNo", orderResult.getOrderId());
        dataMap.put("version", "1.0.0");
        dataMap.put("deviceType", "0601");
        dataMap.put("mhtCharset", "UTF-8");
        dataMap.put("mhtSignType", "MD5");
        try {
            dataMap.put("mhtSignature", MD5Facade.getFormDataParamMD5((Map)dataMap, (String)NowPayAppUtil.getAppKey(), (String)"UTF-8"));
            String queryForm = FormDataConvertUtil.postFormLinkReportWithURLEncode((Map)dataMap);
            String resultCode = HttpClientUtil.postData((String)NowPayAppUtil.getNowpayUrl(), (String)queryForm);
            Map resultMap = FormDataConvertUtil.parseFormDataPatternReportWithDecode((String)resultCode);
            boolean isValidSignature = SignCheckUtil.signCheck((Map)resultMap, (Boolean)Boolean.FALSE, (String)NowPayAppUtil.getAppKey());
            String transStatus = (String)resultMap.get("transStatus");
            if (isValidSignature && "A001".equals(transStatus)) {
                payResult.setOrderId((String)resultMap.get("mhtOrderNo"));
                payResult.setPayAmt(Integer.valueOf((String)resultMap.get("mhtOrderAmt")));
                payResult.setPayerId((String)resultMap.get("payConsumerId"));
                payResult.setSuccess(Boolean.TRUE.booleanValue());
                payResult.setOutTradeNo((String)resultMap.get("nowPayOrderNo"));
            } else {
                payResult.setSuccess(Boolean.FALSE.booleanValue());
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u73b0\u5728\u652f\u4ed8\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38 msg={}", (Object[])new Object[]{e.getMessage()});
        }
        return payResult;
    }

    @Override
    PayTypeEnum getPayType() {
        return PayTypeEnum.NOWPAY;
    }

    public void afterPropertiesSet() throws Exception {
        PayChannelDecider.registPaychannel(this.getPayType(), this);
    }
}

