/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import com.google.common.base.Objects;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.common.util.AppLogUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PayChannelProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PayChannelProcessor.class);
    @Autowired
    private FundOrderService fundOrderService;

    public abstract boolean verify(Map<String, String> var1);

    public abstract String payExecute(String var1);

    public void processNotify(AsyncAcceptParams params) {
        List<FundOrderDto> list = this.fundOrderService.findByOrderIdAndBizType(params.getOrderId(), FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isEmpty(list)) {
            AppLogUtil.warn((Logger)LOG, (String)"\u67e5\u4e0d\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f\uff0c\u5ffd\u7565\u652f\u4ed8\u901a\u77e5\uff0corderId={}, outSeqNo={}", (Object[])new Object[]{params.getOrderId(), params.getOutSqeNo()});
            return;
        }
        FundOrderDto payOrder = list.get(0);
        String originalFundStatus = payOrder.getFundStatus();
        if (!Objects.equal((Object)params.getReceiptAmount(), (Object)payOrder.getAmt())) {
            AppLogUtil.warn((Logger)LOG, (String)"\u652f\u4ed8\u91d1\u989d\u3010{}\u3011\u4e0e\u8ba2\u5355\u91d1\u989d\u3010{}\u3011\u4e0d\u4e00\u81f4", (Object[])new Object[]{params.getReceiptAmount(), payOrder.getAmt()});
            return;
        }
        if (this.needRefund(payOrder.getPayType(), payOrder.getFundStatus())) {
            AppLogUtil.warn((Logger)LOG, (String)"\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f\u4e3a\u8d27\u5230\u4ed8\u6b3e\uff0c\u6216\u5df2\u652f\u4ed8\u3002\u53d1\u8d77\u9000\u6b3e,orderId={}", (Object[])new Object[]{params.getOrderId()});
            this.fundOrderService.refund(params.getOrderId(), this.getPayType().getCode(), payOrder.getAmt());
        } else {
            if (StringUtils.equals((CharSequence)payOrder.getPayType(), (CharSequence)this.getPayType().getCode()) && StringUtils.equals((CharSequence)originalFundStatus, (CharSequence)FundStatusEnum.SUCCESS.getCode())) {
                AppLogUtil.warn((Logger)LOG, (String)"\u6536\u5230\u91cd\u590d\u6d88\u606f\uff0c\u5ffd\u7565\uff0corderId={}, outSeqNo={}", (Object[])new Object[]{params.getOrderId(), params.getOutSqeNo()});
                return;
            }
            payOrder.setPayType(this.getPayType().getCode());
            payOrder.setFundStatus(FundStatusEnum.SUCCESS.getCode());
            payOrder.setOutSeqNo(params.getOutSqeNo());
            payOrder.setAccount(params.getAccount());
            this.doProcess(payOrder, originalFundStatus);
        }
    }

    private void doProcess(FundOrderDto payOrder, String originalFundStatus) {
        this.fundOrderService.notifySuccess(payOrder, originalFundStatus);
    }

    private boolean needRefund(String payType, String fundStatus) {
        return StringUtils.equals((CharSequence)fundStatus, (CharSequence)FundStatusEnum.FAILED.getCode()) || StringUtils.equals((CharSequence)PayTypeEnum.COD.getCode(), (CharSequence)payType) || !StringUtils.equals((CharSequence)payType, (CharSequence)this.getPayType().getCode()) && StringUtils.equals((CharSequence)fundStatus, (CharSequence)FundStatusEnum.SUCCESS.getCode());
    }

    public abstract void refund(String var1, String var2, Integer var3);

    public abstract RefundResult refundQuery(String var1, String var2);

    abstract PayTypeEnum getPayType();

    public abstract PayDto queryPayResult(String var1);
}

