/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderService;
import com.qiho.center.biz.bo.OrderBo;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.SmsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteOrderServiceImpl
implements RemoteOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteOrderServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private OrderSnapshotService orderSnapshotService;
    @Autowired
    private OrderBo orderBo;

    public DubboResult<String> submit(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        try {
            String orderId = this.orderService.createOrder(order, channelInfo, payType);
            return DubboResult.successResult((Object)orderId);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.submit failed, order={}, channelInfo={}", new Object[]{order, channelInfo, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sendSmsCode(String mobile, String smsCode) {
        try {
            boolean result = this.smsService.sendSmsCode(mobile, smsCode);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.sendSmsCode failed, mobile={}, smsCode={}", new Object[]{mobile, smsCode, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PagenationDto<OrderSnapshotDto>> findAllPage(OrderPageParams params) {
        return DubboResult.successResult(this.orderSnapshotService.findOrderPage(params));
    }

    public DubboResult<Integer> findAllPageCount(OrderPageParams params) {
        return DubboResult.successResult((Object)this.orderSnapshotService.findAllPageCount(params));
    }

    public DubboResult<List<OrderSnapshotDto>> exportAllOrderPage(OrderPageParams params) {
        return DubboResult.successResult(this.orderSnapshotService.findOrderPageForExport(params));
    }

    public DubboResult<Integer> exportOrderPageCount(OrderPageParams params) {
        return DubboResult.successResult((Object)this.orderSnapshotService.exportOrderPageCount(params));
    }

    public DubboResult<Integer> batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        return DubboResult.successResult((Object)this.orderBo.batchAuditOrder(progressKey, paramList));
    }

    public DubboResult<Boolean> auditOrder(OrderAuditParams params) {
        try {
            return DubboResult.successResult((Object)this.orderService.auditOrder(params));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.auditOrder failed,orderId={}", (Object)params.getOrderId(), (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrderDto> findByOrderId(String orderId) {
        try {
            OrderDto orderDto = this.orderService.findByOrderId(orderId);
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findByOrderId failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrderSnapshotDto> findOrderSnapshot(String orderId) {
        try {
            OrderSnapshotDto orderSnapshotDto = this.orderSnapshotService.findByOrderId(orderId);
            return DubboResult.successResult((Object)orderSnapshotDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.findOrderSnapshot failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderItem(OrderItemParam param) {
        try {
            this.orderService.updateOrderItem(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderItem failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderConsumer(OrderConsumerParam param) {
        try {
            this.orderService.updateOrderConsumer(param);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderConsumer failed,param={}", (Object)param, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateOrderStatus(String orderId, String orderStatus) {
        try {
            this.orderService.updateOrderStatus(orderId, OrderStatusEnum.getByCode((String)orderStatus));
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteOrderService.updateOrderStatus failed, orderId={}, orderStatus={}", new Object[]{orderId, orderStatus, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

