/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.bo.ErpOrderBo;
import com.qiho.center.biz.service.order.ErpOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DealWithErpOrderDeliverRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DealWithErpOrderDeliverRunnable.class);
    @Autowired
    private ErpOrderBo erpOrderBo;
    @Autowired
    private ErpOrderService erpOrderService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<BatchResolveErpDeliverParams> paramsList = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;

    public Integer init() {
        return this.paramsList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        failCount = 0L;
        try lbl-1000:
        // 6 sources

        {
            block12: for (BatchResolveErpDeliverParams param : this.paramsList) {
                try {
                    switch (param.getDealResult()) {
                        case 1: {
                            this.resolveDeliver(param);
                            ** break;
                        }
                        case 0: {
                            this.rejectDeliver(param);
                            continue block12;
                        }
                        ** default:
lbl13:
                        // 1 sources

                        continue block12;
                    }
                }
                catch (Exception e) {
                    ++failCount;
                    this.logger.error("ERP\u5904\u7406", (Throwable)e);
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    private void resolveDeliver(BatchResolveErpDeliverParams params) {
        ErpOrderDto erp = this.findEnableErpOrder(params.getOrderId());
        if (Objects.equal(null, (Object)erp)) {
            throw new QihoException("\u8be5\u8ba2\u5355\u4e0b\u672a\u627e\u5230\u5f85\u901a\u77e5\u7684ERP\u8ba2\u5355");
        }
        ResolveDeliverParams pp = new ResolveDeliverParams();
        pp.setExpress(params.getExpress());
        pp.setExpressCode(params.getExpressCode());
        pp.setErpId(erp.getErpId());
        this.erpOrderBo.resolveDeliver(pp);
    }

    private void rejectDeliver(BatchResolveErpDeliverParams params) {
        ErpOrderDto erp = this.findEnableErpOrder(params.getOrderId());
        if (Objects.equal(null, (Object)erp)) {
            throw new QihoException("\u8be5\u8ba2\u5355\u4e0b\u672a\u627e\u5230\u5f85\u901a\u77e5\u7684ERP\u8ba2\u5355");
        }
        this.erpOrderBo.cancelDeliver(erp.getErpId());
    }

    private ErpOrderDto findEnableErpOrder(String orderId) {
        List<ErpOrderDto> list = this.erpOrderService.findByOrderId(orderId);
        ErpOrderDto erp = null;
        for (ErpOrderDto dto : list) {
            if (!Objects.equal((Object)dto.getErpStatus(), (Object)ErpStatusEnum.TO_NOTIFY.getCode())) continue;
            erp = dto;
            break;
        }
        return erp;
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParamsList(List<BatchResolveErpDeliverParams> paramsList) {
        this.paramsList.addAll(paramsList);
    }
}

