/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.dto.NewStockReqDto;
import cn.com.duiba.stock.service.api.dto.NewStockRespDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemSkuServiceImpl
implements ItemSkuService {
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;

    @Override
    public List<ItemSkuDto> getSkuByItemId(Long itemId) {
        List skuEntityList = this.qihoItemSkuDAO.getSkuByItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ArrayList skuDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)skuEntityList)) {
            return skuDtoList;
        }
        ArrayList stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuEntityList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        for (QihoItemSkuEntity skuEntity : skuEntityList) {
            ItemSkuDto skuDto = (ItemSkuDto)BeanUtils.copy((Object)skuEntity, ItemSkuDto.class);
            skuDto.setStock((Long)stockMap.get(skuEntity.getStockId()));
            skuDto.setStockId(skuEntity.getStockId());
            skuDtoList.add(skuDto);
        }
        return skuDtoList;
    }

    @Override
    @Transactional(value="QIHO")
    public void updateItemSku(List<ItemSkuDto> skuList, Long itemId) {
        if (CollectionUtils.isEmpty(skuList) || itemId == null) {
            return;
        }
        ArrayList skuIds = Lists.newArrayList();
        ArrayList createSkuList = Lists.newArrayList();
        ArrayList modifySkuList = Lists.newArrayList();
        for (ItemSkuDto skuDto : skuList) {
            if (skuDto.getId() != null) {
                skuIds.add(skuDto.getId());
                modifySkuList.add(skuDto);
                continue;
            }
            QihoItemSkuEntity skuEntity = (QihoItemSkuEntity)BeanUtils.copy((Object)skuDto, QihoItemSkuEntity.class);
            skuEntity.setItemId(itemId);
            skuEntity.setDeleted(Boolean.valueOf(false));
            createSkuList.add(skuEntity);
        }
        if (CollectionUtils.isNotEmpty((Collection)skuIds)) {
            this.qihoItemSkuDAO.deleteNotIn((List)skuIds, itemId);
        } else {
            this.qihoItemSkuDAO.deleteByItemId(itemId);
        }
        this.createSku(createSkuList);
        this.modifySku(modifySkuList);
    }

    private void modifySku(List<ItemSkuDto> modifySkuList) {
        if (CollectionUtils.isEmpty(modifySkuList)) {
            return;
        }
        ArrayList skuList = Lists.newArrayList();
        ArrayList decreaseList = Lists.newArrayList();
        ArrayList increaseList = Lists.newArrayList();
        for (ItemSkuDto skuDto : modifySkuList) {
            skuList.add(BeanUtils.copy((Object)skuDto, QihoItemSkuEntity.class));
            Long stockChanges = skuDto.getStockChanges();
            if (stockChanges == null) continue;
            UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
            if (skuDto.getStockId() == null) continue;
            updateStockReqDto.setStockId(skuDto.getStockId().longValue());
            updateStockReqDto.setStock(Math.abs(stockChanges));
            if (stockChanges < 0L) {
                decreaseList.add(updateStockReqDto);
                continue;
            }
            if (stockChanges <= 0L) continue;
            increaseList.add(updateStockReqDto);
        }
        this.qihoItemSkuDAO.updateBatch((List)skuList);
        if (CollectionUtils.isNotEmpty((Collection)decreaseList)) {
            this.remoteStockBackendService.decreaseItemStockBatch((List)decreaseList);
        }
        if (CollectionUtils.isNotEmpty((Collection)increaseList)) {
            this.remoteStockBackendService.increaseItemStockBatch((List)increaseList);
        }
    }

    private void createSku(List<QihoItemSkuEntity> createSkuList) {
        if (CollectionUtils.isEmpty(createSkuList)) {
            return;
        }
        this.qihoItemSkuDAO.insertBatch(createSkuList);
        ArrayList stockReqList = Lists.newArrayList();
        HashMap skuMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : createSkuList) {
            skuMap.put(skuEntity.getId(), skuEntity);
            NewStockReqDto stockReq = new NewStockReqDto();
            stockReq.setGid(skuEntity.getId().longValue());
            stockReq.setStock(skuEntity.getStock().longValue());
            stockReqList.add(stockReq);
        }
        List stockRespList = (List)this.remoteStockBackendService.newStockBatch((List)stockReqList).getResult();
        for (NewStockRespDto stockResp : stockRespList) {
            QihoItemSkuEntity skuEntity = (QihoItemSkuEntity)skuMap.get(stockResp.getGid());
            skuEntity.setStockId(Long.valueOf(stockResp.getStockId()));
        }
        this.qihoItemSkuDAO.updateBatch(createSkuList);
    }

    @Override
    public ItemSkuDto querySku(Long skuId) {
        QihoItemSkuEntity entity = this.qihoItemSkuDAO.findById(skuId);
        if (entity == null) {
            return null;
        }
        ItemSkuDto sku = (ItemSkuDto)BeanUtils.copy((Object)entity, ItemSkuDto.class);
        DubboResult result = this.remoteStockService.find(entity.getStockId().longValue());
        sku.setStock((Long)result.getResult());
        return sku;
    }
}

