/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.SkuPropertyDto;
import com.qiho.center.api.dto.SkuPropertyValueDto;
import com.qiho.center.biz.service.SkuPropertyService;
import com.qiho.center.common.dao.QihoSkuPropertyNameDAO;
import com.qiho.center.common.dao.QihoSkuPropertyValueDAO;
import com.qiho.center.common.entity.item.QihoSkuPropertyNameEntity;
import com.qiho.center.common.entity.item.QihoSkuPropertyValueEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkuPropertyServiceImpl
implements SkuPropertyService {
    @Autowired
    private QihoSkuPropertyNameDAO qihoSkuPropertyNameDAO;
    @Autowired
    private QihoSkuPropertyValueDAO qihoSkuPropertyValueDAO;

    @Override
    public List<SkuPropertyDto> getSkuPropertyByItemId(Long itemId) {
        SkuPropertyValueDto dto;
        List propertyNameEntityList = this.qihoSkuPropertyNameDAO.findByItemId(itemId);
        ArrayList skuPropertyList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)propertyNameEntityList)) {
            return skuPropertyList;
        }
        ArrayList propertyNameIds = Lists.newArrayList();
        for (QihoSkuPropertyNameEntity propertyName : propertyNameEntityList) {
            propertyNameIds.add(propertyName.getId());
        }
        List propertyValueEntityList = this.qihoSkuPropertyValueDAO.findByPropertyNameIds((List)propertyNameIds);
        HashMap propertyValueMap = Maps.newHashMap();
        for (QihoSkuPropertyValueEntity value : propertyValueEntityList) {
            dto = (SkuPropertyValueDto)BeanUtils.copy((Object)value, SkuPropertyValueDto.class);
            Long propertyNameId = value.getPropertyNameId();
            List list = (List)propertyValueMap.get(propertyNameId);
            if (CollectionUtils.isEmpty((Collection)list)) {
                propertyValueMap.put(propertyNameId, Lists.newArrayList((Object[])new SkuPropertyValueDto[]{dto}));
                continue;
            }
            list.add(dto);
        }
        for (QihoSkuPropertyNameEntity propertyName : propertyNameEntityList) {
            dto = (SkuPropertyDto)BeanUtils.copy((Object)propertyName, SkuPropertyDto.class);
            dto.setPropertyValueList((List)propertyValueMap.get(propertyName.getId()));
            skuPropertyList.add(dto);
        }
        return skuPropertyList;
    }

    @Override
    public void updateItemId(List<SkuPropertyDto> propertyList, Long itemId) {
        if (CollectionUtils.isEmpty(propertyList)) {
            return;
        }
        ArrayList propertyNameIds = Lists.newArrayList();
        for (SkuPropertyDto dto : propertyList) {
            propertyNameIds.add(dto.getId());
        }
        this.qihoSkuPropertyNameDAO.updateItemIdByIds((List)propertyNameIds, itemId);
    }

    @Override
    public Map<Long, String> createPropertyNames(List<String> propertyNames) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(propertyNames)) {
            return map;
        }
        ArrayList list = Lists.newArrayList();
        for (String name : propertyNames) {
            QihoSkuPropertyNameEntity entity = new QihoSkuPropertyNameEntity();
            entity.setPropertyName(name);
            entity.setNameEnable(Boolean.valueOf(false));
            list.add(entity);
        }
        this.qihoSkuPropertyNameDAO.insertBatch((List)list);
        for (QihoSkuPropertyNameEntity entity : list) {
            map.put(entity.getId(), entity.getPropertyName());
        }
        return map;
    }

    @Override
    public Map<Long, String> createPropertyValues(List<SkuPropertyValueDto> propertyValues) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(propertyValues)) {
            return map;
        }
        ArrayList list = Lists.newArrayList();
        for (SkuPropertyValueDto propertyValue : propertyValues) {
            QihoSkuPropertyValueEntity entity = new QihoSkuPropertyValueEntity();
            entity.setPropertyNameId(propertyValue.getPropertyNameId());
            entity.setPropertyValue(propertyValue.getPropertyValue());
            entity.setValueEnable(Boolean.valueOf(false));
            list.add(entity);
        }
        this.qihoSkuPropertyValueDAO.insertBatch((List)list);
        for (QihoSkuPropertyValueEntity entity : list) {
            map.put(entity.getId(), entity.getPropertyValue());
        }
        return map;
    }

    @Override
    @Transactional(value="QIHO")
    public void enableProperty(List<SkuPropertyDto> propertyList, Long itemId) {
        ArrayList propertyNameIds = Lists.newArrayList();
        ArrayList propertyValueIds = Lists.newArrayList();
        for (SkuPropertyDto property : propertyList) {
            propertyNameIds.add(property.getId());
            for (SkuPropertyValueDto value : property.getPropertyValueList()) {
                propertyValueIds.add(value.getId());
            }
        }
        List dbNameList = this.qihoSkuPropertyNameDAO.findByItemId(itemId);
        ArrayList dbPropertyNameIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dbNameList)) {
            ArrayList delNameIds = Lists.newArrayList();
            for (QihoSkuPropertyNameEntity entity : dbNameList) {
                dbPropertyNameIds.add(entity.getId());
                delNameIds.add(entity.getId());
            }
            delNameIds.removeAll(propertyNameIds);
            if (CollectionUtils.isNotEmpty((Collection)delNameIds)) {
                this.qihoSkuPropertyNameDAO.deleteByIds((List)delNameIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)propertyNameIds)) {
            this.qihoSkuPropertyNameDAO.enablePropertyName((List)propertyNameIds);
        }
        List dbValueList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dbPropertyNameIds)) {
            dbValueList = this.qihoSkuPropertyValueDAO.findByPropertyNameIds((List)dbPropertyNameIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)dbValueList)) {
            ArrayList delValueIds = Lists.newArrayList();
            for (QihoSkuPropertyValueEntity entity : dbValueList) {
                delValueIds.add(entity.getId());
            }
            delValueIds.removeAll(propertyValueIds);
            if (CollectionUtils.isNotEmpty((Collection)delValueIds)) {
                this.qihoSkuPropertyValueDAO.deleteByIds((List)delValueIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)propertyValueIds)) {
            this.qihoSkuPropertyValueDAO.enablePropertyValue((List)propertyValueIds);
        }
    }
}

