/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.event.FundInfoUpdateEvent;
import com.qiho.center.biz.event.UpdateToCodEvent;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.fund.QihoFundOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FundOrderServiceImpl
implements FundOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(FundOrderServiceImpl.class);
    @Autowired
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private BizEventBus bizEventBus;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PayChannelDecider payChannelDecider;

    @Override
    public List<FundOrderDto> findByOrderId(String orderId) {
        return BeanUtils.copyList((List)this.qihoFundOrderDAO.findByOrderId(orderId), FundOrderDto.class);
    }

    @Override
    public PagenationDto<FundOrderDto> queryFundPage(FundPageParam param) {
        PagenationDto pagenation = new PagenationDto();
        int count = this.qihoFundOrderDAO.countByParam(param);
        pagenation.setTotal(Integer.valueOf(count));
        if (count > 0) {
            List list = this.qihoFundOrderDAO.queryPage(param);
            List fundList = BeanUtils.copyList((List)list, FundOrderDto.class);
            pagenation.setList(fundList);
        }
        return pagenation;
    }

    @Override
    public List<FundOrderDto> findByOrderIdAndBizType(String orderId, String bizType) {
        return BeanUtils.copyList((List)this.qihoFundOrderDAO.findByOrderIdAndBizType(orderId, bizType), FundOrderDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public void notifySuccess(FundOrderDto fundOrder, String originalFundStatus) {
        this.updateFundOrder(fundOrder, originalFundStatus, OrderStatusEnum.TO_APPROVE);
        OrderAuditParams params = new OrderAuditParams();
        params.setOrderId(fundOrder.getOrderId());
        params.setAuditResult(Integer.valueOf(1));
        this.orderService.auditOrder(params);
        FundInfoUpdateEvent event = new FundInfoUpdateEvent();
        event.setOrderAmt(fundOrder.getAmt());
        event.setFundStatus(fundOrder.getFundStatus());
        event.setOrderId(fundOrder.getOrderId());
        event.setPayType(fundOrder.getPayType());
        this.bizEventBus.post((Object)event);
    }

    private void updateFundOrder(FundOrderDto fundOrder, String originalFundStatus, OrderStatusEnum orderStatus) {
        QihoFundOrderEntity updateFundOrder = this.qihoFundOrderDAO.lockByOrderIdAndType(fundOrder.getOrderId(), fundOrder.getBizType(), originalFundStatus);
        if (updateFundOrder == null) {
            throw new QihoException("\u4ed8\u6b3e\u5b50\u8ba2\u5355\u52a0\u9501\u5931\u8d25\uff0cfundId=" + fundOrder.getFundId());
        }
        updateFundOrder.setAccount(fundOrder.getAccount());
        updateFundOrder.setPayType(fundOrder.getPayType());
        updateFundOrder.setFundStatus(fundOrder.getFundStatus());
        updateFundOrder.setOutSeqNo(fundOrder.getOutSeqNo());
        this.qihoFundOrderDAO.update((QihoFundOrderEntity)BeanUtils.copy((Object)fundOrder, QihoFundOrderEntity.class));
        this.qihoOrderDAO.updateOrderStatus(fundOrder.getOrderId(), orderStatus);
        QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
        orderSnapshot.setOrderId(fundOrder.getOrderId());
        orderSnapshot.setPayType(fundOrder.getPayType());
        orderSnapshot.setFundStatus(fundOrder.getFundStatus());
        orderSnapshot.setOrderStatus(orderStatus.getCode());
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
    }

    @Override
    public void refund(String orderId, String payType, Integer amt) {
        QihoFundOrderEntity entity = new QihoFundOrderEntity();
        entity.setOrderId(orderId);
        String bizId = StringUtils.substring((String)orderId, (int)(StringUtils.indexOf((CharSequence)orderId, (CharSequence)SeqBizTypeEnum.ORDER.getCode()) + 1));
        String fundId = this.builder.createSeqNo(SeqBizTypeEnum.FUND, Long.valueOf(bizId));
        entity.setFundId(fundId);
        entity.setPayType(payType);
        entity.setAmt(amt);
        entity.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        entity.setBizType(FundBizTypeEnum.REFUND.getCode());
        this.qihoFundOrderDAO.initFundOrder(entity);
        PayChannelProcessor payChannelProcessor = this.payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode((String)payType));
        payChannelProcessor.refund(orderId, fundId, amt);
    }

    @Override
    @Transactional(value="QIHO")
    public void updatePayType(FundOrderDto fundOrder, String originalFundStatus) {
        OrderStatusEnum orderStatus = StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) ? OrderStatusEnum.TO_APPROVE : OrderStatusEnum.TO_PAY;
        this.updateFundOrder(fundOrder, originalFundStatus, orderStatus);
        if (StringUtils.equals((CharSequence)fundOrder.getPayType(), (CharSequence)PayTypeEnum.COD.getCode())) {
            UpdateToCodEvent event = new UpdateToCodEvent();
            event.setOrderId(fundOrder.getOrderId());
            this.bizEventBus.post((Object)event);
        }
    }

    @Override
    public int update(FundOrderDto fundOrder) {
        return this.qihoFundOrderDAO.update((QihoFundOrderEntity)BeanUtils.copy((Object)fundOrder, QihoFundOrderEntity.class));
    }

    @Override
    public FundOrderDto findByFundId(String fundId) {
        QihoFundOrderEntity entity = this.qihoFundOrderDAO.findByFundId(fundId);
        return (FundOrderDto)BeanUtils.copy((Object)entity, FundOrderDto.class);
    }
}

