/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.biz.event.FundInfoUpdateEvent;
import com.qiho.center.biz.event.LogisticsUpdateEvent;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.constant.Environment;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.ShortUrlUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class SmsServiceImpl
implements SmsService {
    private static final Logger LOG = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Value(value="${yunpian.sms.url}")
    private String smsUrl;
    @Value(value="${yunpian.apikey}")
    private String apikey;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;

    @Override
    public boolean sendSmsCode(String mobile, String smsCode) {
        HashMap context = Maps.newHashMap();
        context.put("code", smsCode);
        return this.sendMessage(SmsTemplateEnum.SMS_CODE, context, mobile);
    }

    @Override
    public boolean singleSend(String text, String mobile) {
        if (Environment.isDaily() || Environment.isDev()) {
            AppLogUtil.warn((Logger)LOG, (String)"\u6d4b\u8bd5\u73af\u5883\u4e0d\u53d1\u9001\u77ed\u4fe1, text={}, mobile={}", (Object[])new Object[]{text, mobile});
            return true;
        }
        HashMap params = Maps.newHashMap();
        params.put("apikey", this.apikey);
        params.put("text", text);
        params.put("mobile", mobile);
        Integer returnCode = -1;
        try {
            JSONObject json;
            String resp = HttpClientUtil.sendPost((String)this.smsUrl, (Map)params);
            if (StringUtils.isNotBlank((CharSequence)resp) && (returnCode = (json = JSON.parseObject((String)resp)).getInteger("code")) != 0) {
                LOG.warn("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff0cmobile=" + mobile + ", resp=" + resp);
            }
        }
        catch (Exception e) {
            LOG.warn("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1amobile=" + mobile, (Throwable)e);
        }
        return returnCode == 0;
    }

    @Subscribe
    public void updateLogisticsListener(LogisticsUpdateEvent event) {
        String orderId = event.getOrderId();
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (Objects.equal(null, (Object)order) || StringUtils.isBlank((CharSequence)order.getMobile())) {
            LOG.info("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1.orderId={}", (Object)orderId);
            return;
        }
        String mobile = order.getMobile();
        YTOLogisticsStatusEnum status = event.getLogisticsStatus();
        switch (status) {
            case SENT_SCAN: {
                SmsTemplateEnum sendTemplate = StringUtils.equals((CharSequence)order.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) ? SmsTemplateEnum.ORDER_DELIVERY : SmsTemplateEnum.ORDER_DELIVERY_PAID;
                this.sendMessage(sendTemplate, null, mobile);
                break;
            }
            case SIGNED: {
                this.sendMessage(SmsTemplateEnum.ORDER_RECIVED, null, mobile);
                break;
            }
            default: {
                LOG.info("\u4e0d\u9700\u8981\u53d1\u9001\u77ed\u4fe1\u7684\u72b6\u6001\uff0cstatus=" + status.getCode());
            }
        }
    }

    @Subscribe
    public void paySuccessListener(FundInfoUpdateEvent event) {
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(event.getOrderId());
            String mobile = order.getMobile();
            HashMap context = Maps.newHashMap();
            context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId()));
            context.put("itemName", order.getItemShortName());
            String text = SimpleTemplateUtil.render((String)template.getTemplateContext(), (Map)context);
            this.singleSend(text, mobile);
        }
    }

    private boolean sendMessage(SmsTemplateEnum template, Map<String, String> context, String mobile) {
        QihoTemplateEntity entity = this.qihoTemplateDAO.findByCode(template.getCode());
        if (entity.getTemplateEnable().booleanValue()) {
            String text = SimpleTemplateUtil.render((String)entity.getTemplateContext(), context);
            return this.singleSend(text, mobile);
        }
        return true;
    }
}

