package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;

/**
 * Created by danke on 2017/6/23.
 * 用于校验订单详细地址的长度的action
 */
public class AdressLengthAction extends ShotOrderAbstractAction {

    /**
     *订单详细地址长度校验逻辑
     * @return
     */
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) throws Exception {
        String threshold = strategyRuleDto.getThreshold();//阈值
        String adressStr = orderSnapshotDto.getAddress();
        int adresslength = adressStr.trim().length();
        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(threshold,adresslength);
    }


}
