package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.Calendar;

/**
 * Created by danke on 2017/6/21.
 * 验证24小时累计下单下单的action,通过订单本身属性统计的,都可以用这个action
 */
public class RepeatPlaceOrderAction extends ShotOrderAbstractAction {

    /**
     * 注入获取下单count的接口
     */
    @Resource
    private OrderSnapshotService orderSnapshotService;


    /**
     *复杂逻辑具体实现方法,接口中默认方法,子类调用
     * @return
     */
    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) throws Exception {
        String threshold = strategyRuleDto.getThreshold();//阈值
        //封装参数
        String valuteVal = BaseHandler.getValuteVal(orderSnapshotDto,strategyRuleDto);
        if(StringUtils.isBlank(valuteVal))
            return ResultBase.rightReturn(Boolean.FALSE);//如果字段值为空,不做校验,不达标
        String[] valuteFieldNameArr = strategyRuleDto.getFieldName().split("-");
        String valuteFieldName = valuteFieldNameArr[valuteFieldNameArr.length-1];
        OrderPageParams pageParams = new OrderPageParams();
        Field[] fields = pageParams.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (fieldName.equals(valuteFieldName)) {
                field.set(pageParams,valuteVal);
                break;
            }
        }
        this.getStartAndEndTime(pageParams);
        Integer countOrder = orderSnapshotService.findAllPageCount(pageParams);
        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(threshold,countOrder);
    }

    /**
     * 获取startTime和endTime
     * 因为个服务器时间点存在微差,所以讲时间往后推一个小时区间,
     */
    private OrderPageParams getStartAndEndTime(OrderPageParams orderPageParams){
        Calendar calendar = Calendar.getInstance();
        /* HOUR_OF_DAY 指示一天中的小时 */
        calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - 24);
        orderPageParams.setStartTime(calendar.getTime());
        calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) + 25);
        orderPageParams.setEndTime(calendar.getTime());
        return orderPageParams;
    }

}
