package com.qiho.center.biz.engine.chain;

import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.ProcessContext;
import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/6/21.
 * 辅助校验链路入口,上车啦
 */
public class BusEntiyHandler implements BaseHandler{

    private BaseHandler baseHandler;

    @Override
    public ResultBase<Boolean> handleRequest(ProcessContext context) throws Exception {
        if (null == context)
            throw new QihoException("校验执行链路上下文为空");
        if (null == context.getOrderSnapshotDto())
            throw new QihoException("订单信息为空,请检查上游数据情况");
        if (null == context.getStrategyRuleDto())
            throw new QihoException("校验规则信息为空,请检查上游数据情况");
        if (StringUtils.isBlank(context.getStrategyRuleDto().getFieldName()) || StringUtils.isBlank(context.getStrategyRuleDto().getRuleName()))
            throw new QihoException("策略参数配置非法,请检查策略相关配置");
        return baseHandler.handleRequest(context);
    }

    public BaseHandler getBaseHandler() {
        return baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}
