package com.qiho.center.biz.engine.chain;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.ProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Created by danke on 2017/6/21.
 * 进行链路划分的handler,简单链路直接在这层处理
 */
public class ExecuteHandler implements BaseHandler {

    Logger logger = LoggerFactory.getLogger(getClass());

    private BaseHandler baseHandler;

    /**
     * 责任链
     * @param context
     * @return
     * @throws Exception
     */
    @Override
    public ResultBase<Boolean> handleRequest(ProcessContext context) throws Exception {
        StrategyRuleDto strategyRuleDto = context.getStrategyRuleDto();
        ShotOrderFieldEnum shotOrderFieldEnum = ShotOrderFieldEnum.fromVal(strategyRuleDto.getFieldName());
        if (null == shotOrderFieldEnum){
            return ResultBase.errorReturn("策略配置有误,需要校验的字段信息配置错误 fieldName="+strategyRuleDto.getFieldName());
        }
        if(shotOrderFieldEnum.getCode() > 100){//枚举定义,100+为自定义校验
            return baseHandler.handleRequest(context);//责任链,复杂校验,继续往下走
        }else{
            return this.valateOrder(context);
        }
    }

    /**
     * 校验逻辑
     * @param context
     * @return
     * @throws Exception
     */
    private ResultBase<Boolean> valateOrder(ProcessContext context) throws Exception {
        OrderSnapshotDto orderSnapshotDto = context.getOrderSnapshotDto();
        StrategyRuleDto strategyRuleDto = context.getStrategyRuleDto();
        //获取需要校验的字段在订单中的值,空校验放在具体方法中,因为部分校验逻辑就是校验值是否为空
        String valuteVal = BaseHandler.getValuteVal(orderSnapshotDto,strategyRuleDto);
        String thresholdVal = strategyRuleDto.getThreshold();
        return ShotOrderRuleEnum.fromVal(strategyRuleDto.getRuleName()).valuteOrderByQuery(thresholdVal,valuteVal);
    }

    public BaseHandler getBaseHandler() {
        return baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}
