package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.service.order.OrderStrategyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by danke on 2017/6/21.
 * 踢单辅助校验链路入口
 */
public class ShotOrderEngine implements BaseEngine<OrderSnapshotDto> {

    Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 命中后执行处理器的map
     */
    public Map<String,BaseEngine> strategyTask;

    /**
     * 注入策略服务接口
     * @param valuteData
     * @return
     */
    @Resource
    private OrderStrategyService orderStrategyService;

    /**
     * 校验链路入口类
     * @param valuteData
     * @return
     */
    private BaseHandler baseHandler;


    @Override
    public OrderSnapshotDto process(OrderSnapshotDto valuteData) {
        if(null == valuteData)
            return valuteData;
        OrderStrategyParams params = new OrderStrategyParams();
        params.setStrategyType(StrategyType.SHOT_ORDER.getCode());
        try{
            //查询所有策略,循环校验
            List<OrderStrategyDto> orderStrategyDtos = orderStrategyService.findStrategyByQuery(params,null,null).getList();
            //查询校验策略,如果为空,直接返回
            if (CollectionUtils.isEmpty(orderStrategyDtos))
                return valuteData;
            //循环执行校验策略
            for (OrderStrategyDto orderStrategyDto : orderStrategyDtos){
                Boolean flag = Boolean.TRUE;//用来标记返回值,falg决定后续对订单的处理
                ResultBase<List<StrategyRuleDto>> resultBase = validateorderStrategyDto(orderStrategyDto);
                if(!resultBase.hasSuccessValue()) {
                    logger.warn(resultBase.getErrorMsg());
                    continue;
                }
                List<StrategyRuleDto> strategyRuleDtos =resultBase.getValue();
                ProcessContext processContext = null;
                for (StrategyRuleDto strategyRuleDto : strategyRuleDtos){
                    //真正校验执行
                    processContext = ProcessFaceory.createProcessContext(valuteData,strategyRuleDto,orderStrategyDto);
                    ResultBase<Boolean> checkResult = baseHandler.handleRequest(processContext);
                    if (checkResult.hasSuccessValue()){
                        flag = flag && checkResult.getValue();
                    }else{
                        flag = Boolean.FALSE;
                        logger.warn("本条策略规则校验失败 msg={} strategyName={} ruleName={} fieldName={}",
                                checkResult.getErrorMsg(),orderStrategyDto.getStrategyName(),strategyRuleDto.getRuleName(),strategyRuleDto.getFieldName());
                        break;//跳出本策略的循环,其中一环错误,校验无意义
                    }
                }
                //命中后执行链路
                if(flag && null != strategyTask){
                    BaseEngine baseEngine = strategyTask.get(orderStrategyDto.getHandlerName());
                    if (null != baseEngine)
                        baseEngine.process(processContext);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error("策略过滤链路失败 msg={} data={}",e.getLocalizedMessage(),valuteData.toString());
        }
        return valuteData;
    }


    /**
     * 校验策略是否为空
     * @param orderStrategyDto
     * @return
     * @throws Exception
     */
    private ResultBase<List<StrategyRuleDto>> validateorderStrategyDto(OrderStrategyDto orderStrategyDto){
        ResultBase<List<StrategyRuleDto>> resultBase = new ResultBase<>();
        if(StringUtils.isBlank(orderStrategyDto.getRulevalue()))
            return resultBase.setErrorReturn("策略为空,不校验");
        List<StrategyRuleDto> strategyRuleDtos = JSONObject.parseArray(orderStrategyDto.getRulevalue(),StrategyRuleDto.class);
        if(CollectionUtils.isEmpty(strategyRuleDtos))
            return resultBase.setErrorReturn("此策略的策略规则值为空,不校验 strategyName="+orderStrategyDto.getStrategyName());
        return resultBase.setRightReturn(strategyRuleDtos);
    }

    public BaseHandler getBaseHandler() {
        return baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public Map<String, BaseEngine> getStrategyTask() {
        return strategyTask;
    }

    public void setStrategyTask(Map<String, BaseEngine> strategyTask) {
        this.strategyTask = strategyTask;
    }
}
