/**
 * Project Name:qiho-center-biz File Name:LogisticsStatusFixJob.java Package Name:com.qiho.center.biz.job
 * Date:2017年7月3日下午9:45:03 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.job;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.util.AppLogUtil;

/**
 * ClassName:LogisticsStatusFixJob <br/>
 * 物流状态修正任务. <br/>
 * Date: 2017年7月3日 下午9:45:03 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class LogisticsStatusFixJob extends AbstractQihoSimpleElasticJob {
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsStatusFixJob.class);
    @Autowired
    private LogisticsOrderService logisticsOrderService;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn(LOG, "################ 开始执行定时任务【LogisticsStatusFixJob】 ################");
        int pageSize = 100;
        int pageNum = 1;
        while (true) {
            List<LogisticsOrderEntity> list = logisticsOrderService.queryListToFix(pageNum, pageSize);
            if (CollectionUtils.isEmpty(list)) {
                break;
            }
            logisticsOrderService.doSync(list);
            pageNum++;
        }
    }

}
