package com.qiho.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.api.remoteservice.RemoteConfigService;
import com.qiho.center.biz.service.ConfigService;

/**
 * @author chensong
 * @create 2017-07-17 17:07
 **/
@Service
public class RemoteConfigServiceImpl implements RemoteConfigService{

    private Logger logger = LoggerFactory.getLogger(RemoteConfigServiceImpl.class);

    @Autowired
    private ConfigService configService;


    @Override
    public DubboResult<String> findByName(String name) {
        return DubboResult.successResult(configService.findByName(name));
    }

    @Override
    public DubboResult<Integer> saveConfig(ConfigParams param) {
        try{
            return DubboResult.successResult(configService.saveConfig(param));
        }catch (Exception e){
            logger.info("Config保存失败",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ConfigDto>> findAllConfig() {
        return DubboResult.successResult(configService.findAllConfig());
    }

    @Override
    public DubboResult<Integer> updateByName(ConfigParams param) {
        return DubboResult.successResult(configService.updateByName(param));
    }

    @Override
    public DubboResult<String> findValueByPayType(PayTypeEnum type) {
        String name = type.getCode();
        return DubboResult.successResult(configService.findByName(name));
    }


}


