/**
 * Project Name:qiho-center-biz
 * File Name:RemoteItemSkuServiceImpl.java
 * Package Name:com.qiho.center.biz.remoteservice.impl.item
 * Date:2017年6月3日下午3:54:35
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.remoteservice.impl.item;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.remoteservice.item.RemoteItemSkuService;
import com.qiho.center.biz.service.ItemSkuService;


/**
 * ClassName:RemoteItemSkuServiceImpl <br/>
 * Date:     2017年6月3日 下午3:54:35 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteItemSkuServiceImpl implements RemoteItemSkuService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteItemSkuServiceImpl.class);
    @Autowired
    private ItemSkuService itemSkuService;

    @Override
    public DubboResult<ItemSkuDto> querySku(Long skuId) {
        try {
            ItemSkuDto skuDto = itemSkuService.querySku(skuId);
            return DubboResult.successResult(skuDto);
        } catch (Exception e) {
            LOG.error("invoke RemoteItemSkuService.querySku failed, skuId={}", skuId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

