/**
 * Project Name:qiho-center-biz File Name:RemoteFundOrderServiceImpl.java Package
 * Name:com.qiho.center.biz.remoteservice.impl.order Date:2017年6月6日下午1:00:56 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package com.qiho.center.biz.remoteservice.impl.order;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.center.biz.service.order.FundOrderService;

/**
 * ClassName:RemoteFundOrderServiceImpl <br/>
 * Date: 2017年6月6日 下午1:00:56 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteFundOrderServiceImpl implements RemoteFundOrderService {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteFundOrderServiceImpl.class);
    @Autowired
    private FundOrderService    fundOrderService;

    @Override
    public DubboResult<List<FundOrderDto>> findByOrderId(String orderId) {
        try {
            List<FundOrderDto> list = fundOrderService.findByOrderId(orderId);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByOrderId failed,orderId={}", orderId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#queryFundPage(com.qiho.center.api.params.FundPageParam)
     */
    @Override
    public DubboResult<PagenationDto<FundOrderDto>> queryFundPage(FundPageParam param) {
        try {
            PagenationDto<FundOrderDto> page = fundOrderService.queryFundPage(param);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.queryFundPage failed,param={}", param, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#findByOrderIdAndBizType(java.lang.String,
     * java.lang.String)
     */
    @Override
    public DubboResult<List<FundOrderDto>> findByOrderIdAndBizType(String orderId, String bizType) {
        try {
            List<FundOrderDto> list = fundOrderService.findByOrderIdAndBizType(orderId, bizType);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByOrderIdAndBizType failed,orderId={},bizType={}", orderId,
                      bizType, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#notifySuccess(com.qiho.center.api.dto.FundOrderDto)
     */
    @Override
    public DubboResult<Void> notifySuccess(FundOrderDto fundOrder, String originalFundStatus) {
        try {
            fundOrderService.notifySuccess(fundOrder, originalFundStatus);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.notifySuccess failed,fundOrder={}", fundOrder, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#refund(java.lang.String, java.lang.String,
     * java.lang.Integer)
     */
    @Override
    public DubboResult<Void> refund(String orderId, String payType, Integer amt) {
        try {
            fundOrderService.refund(orderId, payType, amt);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.refund failed,orderId={}, payType={}, amt={}", orderId, payType,
                      amt, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * @see com.qiho.center.api.remoteservice.order.RemoteFundOrderService#updatePayType(java.lang.String,
     * java.lang.String)
     */
    @Override
    public DubboResult<Void> updatePayType(FundOrderDto fundOrder, String originalFundStatus) {
        try {
            fundOrderService.updatePayType(fundOrder, originalFundStatus);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.updatePayType failed,fundId={}, payType={}", fundOrder.getFundId(), fundOrder.getPayType(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<FundOrderDto> findByFundId(String fundId) {
        try {
            FundOrderDto list = fundOrderService.findByFundId(fundId);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            LOG.error("invoke RemoteFundOrderService.findByFundId failed,fundId={}", fundId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
