package com.qiho.center.biz.remoteservice.impl.statistics;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.statistics.QueryStatisticsDayDto;
import com.qiho.center.api.dto.statistics.StatisticsDayDto;
import com.qiho.center.api.params.ExportStatisticsDayParams;
import com.qiho.center.api.remoteservice.statistics.RemoteStatisticsDayService;
import com.qiho.center.biz.service.statistics.StatisticsDayService;

/**
 * ClassName: RemoteStatisticsDayServiceImpl <br/>
 * Function: 统计数据dubbo服务. <br/>
 * date: 2017年6月22日 上午10:56:15 <br/>
 *
 * @author chencheng
 * @version
 */
@Service
public class RemoteStatisticsDayServiceImpl implements RemoteStatisticsDayService {

    private Logger               LOG = LoggerFactory.getLogger(RemoteStatisticsDayServiceImpl.class);

    @Autowired
    private StatisticsDayService statisticsDayService;

    @Override
    public DubboResult<PagenationDto<StatisticsDayDto>> queryStatisticsDayPage(QueryStatisticsDayDto queryDto,
                                                                               Integer pageNum, Integer pageSize) {
        try {
            PagenationDto<StatisticsDayDto> page = statisticsDayService.queryStatisticsDayPage(queryDto, pageNum,
                                                                                               pageSize);
            return DubboResult.successResult(page);
        } catch (Exception e) {
            LOG.error("invoke RemoteStatisticsDayService.queryStatisticsDayPage failed, queryDto={}, pageNum={}, pageSize={}",
                      queryDto, pageNum, pageSize, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> findAllStatisticsDayCount(ExportStatisticsDayParams params) {
        try {
            return DubboResult.successResult(statisticsDayService.findAllStatisticsDayCount(params));
        } catch (Exception e) {
            LOG.error("invoke RemoteStatisticsDayService.findAllStatisticsDayCount failed, params={}",
                      params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<StatisticsDayDto>> queryAllStatisticsDay(ExportStatisticsDayParams params) {
        try {
            return DubboResult.successResult(statisticsDayService.queryAllStatisticsDay(params));
        } catch (Exception e) {
            LOG.error("invoke RemoteStatisticsDayService.queryAllStatisticsDay failed, params={}", params.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
