/**
 * Project Name:qiho-center-biz
 * File Name:CategoryService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年5月16日下午9:30:57
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service;

import java.util.List;

import com.qiho.center.api.dto.CategoryDto;

/**
 * ClassName:CategoryService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年5月16日 下午9:30:57 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface CategoryService {

    /**
     * sortByRange:在类目移动范围内排序 <br/>
     * 排序区间为闭区间[startPayload, endPayload]
     *
     * @param pid   父类目ID
     * @param startPayload 排序起始payload值
     * @param endPayload   排序结束payload值
     * @author zhanglihui
     */
    void sortByRange(Long pid, Integer startPayload, Integer endPayload);

    /**
     * 根据父类目ID查询子类目
     *
     * @author zhanglihui
     * @param pid
     * @return List<CategoryDto>
     */
    List<CategoryDto> getCategoryByPid(Long pid);

    /**
     * 根据类目ID删除类目，若删除的是父类目，子类目也会被删除
     *
     * @author zhanglihui
     * @param categoryId
     */
    void deleteCategoryById(Long categoryId);

    /**
     * 更新类目名称
     *
     * @author zhanglihui
     * @param categoryId
     * @param categoryName
     */
    void updateCategoryById(Long categoryId, String categoryName);

    /**
     * 批量新增类目
     *
     * @author zhanglihui
     * @param pid
     * @param categoryList
     * @return List<CategoryDto>
     */
    List<CategoryDto> saveCategory(Long pid, List<String> categoryList);

}

