package com.qiho.center.biz.service;

import java.util.List;

import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.params.ConfigParams;

/**
 * 配置项相关Service
 * Created by chensong on 2017/7/17 0017.
 */
public interface ConfigService {

    /**
     * 插入或更新配置项
     * @param param
     * @return
     */
    int saveConfig(ConfigParams param);

    /**
     * 查找所有配置项
     * @return
     */
    List<ConfigDto> findAllConfig();

    /**
     * 根据名称查找配置项
     * @param name
     * @return
     */
    String findByName(String name);

    /**
     * 根据name更新配置项
     * @param param
     * @return
     */
    int updateByName(ConfigParams param);

}
