package com.qiho.center.biz.service.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BandParams;
import com.qiho.center.biz.service.BandService;
import com.qiho.center.common.dao.QihoBandDAO;
import com.qiho.center.common.entity.item.QihoBandEntity;
import com.qiho.center.common.entity.item.QihoItemRecommendEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 2017/5/24.
 */
@Service
public class BandServiceImpl implements BandService {

    @Autowired
    private QihoBandDAO qihoBandDAO;

    private Ordering ordering = Ordering.natural().reverse().onResultOf(new Function<BandDto, Integer>() {
        @Override
        public Integer apply(BandDto input) {
            return input.getPayload();
        }
    });

    @Override
    public List<BandDto> findAllBand() {
        List<QihoBandEntity> list = qihoBandDAO.findAllBand();
        List<BandDto> newList = Lists.transform(list,(entity)->{
            BandDto dto = new BandDto();
            dto.setId(entity.getId());
            dto.setPayload(entity.getPayload());
            dto.setBandEnable(entity.isBandEnable());
            dto.setBandName(entity.getBandName());
            dto.setImage(entity.getImage());
            dto.setUrl(entity.getUrl());
            return dto;
        });
        return ordering.sortedCopy(newList);
    }

    @Override
    public void saveBand(BandParams params) {
        QihoBandEntity entity = new QihoBandEntity();
        entity.setBandName(params.getBandName());
        entity.setImage(params.getImage());
        if(params.getId()==null){
            entity.setUrl(params.getUrl());
            qihoBandDAO.insertBand(entity);
        }else{
            entity.setId(params.getId());
            qihoBandDAO.updateBandInfo(entity);
        }
    }

    @Override
    public Boolean changeBandShowEnable(Long id) {
        QihoBandEntity entity = qihoBandDAO.find(id);
        Boolean enable = !entity.isBandEnable();
        qihoBandDAO.changeBandShowEnable(id,enable);
        return enable;
    }

    @Override
    public Integer sortBand(List<Long> bandIds) {
        List<QihoBandEntity> list = qihoBandDAO.findAllBand();
        if(bandIds.size()!=list.size()){
            throw new QihoException("传入id和Band总数不一致");
        }
        BandOrdering ordering = new BandOrdering();
        ordering.setBandIds(bandIds);
        list = Lists.transform(list,ordering);

        int count = 0;
        for(QihoBandEntity it : list){
            int ret = qihoBandDAO.updatePayload(it.getId(),it.getPayload());
            count = count + ret;
        }
        return count;
    }

    @Override
    public Integer deleteBand(Long id) {
        return qihoBandDAO.deleteBand(id);
    }

    private class BandOrdering implements Function<QihoBandEntity,QihoBandEntity>{

        private List<Long> bandIds;

        private int maxPayload;

        public void setBandIds(List<Long> bandIds) {
            this.bandIds = bandIds;
            this.maxPayload = bandIds.size()-1;
        }

        @Override
        public QihoBandEntity apply(QihoBandEntity input) {
            int index = bandIds.indexOf(input.getId());
            input.setPayload(maxPayload-index);
            return input;
        }
    }
}
