package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.params.MediaPlanParams;
import com.qiho.center.biz.service.MediaPlanService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoMediaPlanDAO;
import com.qiho.center.common.entity.campaign.QihoMediaPlanEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/6/16.
 */
@Service
public class MediaPlanServiceImpl implements MediaPlanService {

    @Resource
    private QihoMediaPlanDAO qihoMediaPlanDAO;


    @Override
    public MediaPlanDto findById(Long id) {
        QihoMediaPlanEntity entity = qihoMediaPlanDAO.findById(id);
        if (null == entity)
            return null;
        return BeanUtils.copy(entity,MediaPlanDto.class);
    }

    @Override
    public PagenationDto<MediaPlanDto> findByQuery(MediaPlanParams params,Integer pageNum,Integer pageSize) {
        List<MediaPlanDto> mediaPlanDto = new ArrayList<>();
        PagenationDto<MediaPlanDto> planDtoPagenationDto = new PagenationDto<>();
        List<QihoMediaPlanEntity> entities = qihoMediaPlanDAO.findByQuery(params,pageNum,pageSize);
        if (CollectionUtils.isEmpty(entities))
            return planDtoPagenationDto;
        //遍历集合,封装参数
        entities.stream().forEach(e -> mediaPlanDto.add(BeanUtils.copy(e,MediaPlanDto.class)));
        planDtoPagenationDto.setList(mediaPlanDto);
        //查询总数
        Integer total = qihoMediaPlanDAO.countByQuery(params);
        planDtoPagenationDto.setTotal(total);
        return planDtoPagenationDto;
    }


    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer updateMediaPlan(MediaPlanDto mediaPlanDto) {
        return qihoMediaPlanDAO.updateByEntity(mediaPlanDto);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer deleteMediaById(Long id) {
        return qihoMediaPlanDAO.deleteById(id);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer insertMediaPlan(MediaPlanDto mediaPlanDto) {
        Long result =  qihoMediaPlanDAO.insert(mediaPlanDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    @Override
    public Integer countMediaPlanByQuery(MediaPlanParams params) {
        return qihoMediaPlanDAO.countByQuery(params);
    }
}
