package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.biz.service.order.OrderStrategyService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.QihoOrderStrategyDAO;
import com.qiho.center.common.entity.order.QihoOrderStrategyEntity;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/6/21.
 */
@Service
public class OrderStrategyServiceImpl implements OrderStrategyService {

    /**
     * 日志
     */
    Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private QihoOrderStrategyDAO qihoOrderStrategyDAO;


    @Override
    public OrderStrategyDto findStrategyById(Long id) {
        QihoOrderStrategyEntity entity = qihoOrderStrategyDAO.findStrategyById(id);
        if (null == entity)
            return null;
        return BeanUtils.copy(entity,OrderStrategyDto.class);
    }

    @Override
    public PagenationDto<OrderStrategyDto> findStrategyByQuery(OrderStrategyParams params, Integer pageNum, Integer pageSize) {
        List<OrderStrategyDto> channelDtos = new ArrayList<>();
        PagenationDto<OrderStrategyDto> resultBase = new PagenationDto<>();
        List<QihoOrderStrategyEntity> entities = qihoOrderStrategyDAO.findStrategyByQuery(params,pageNum,pageSize);
        if (CollectionUtils.isEmpty(entities))
            return resultBase;
        //遍历集合,封装参数
        entities.stream().forEach(e -> channelDtos.add(BeanUtils.copy(e,OrderStrategyDto.class)));
        resultBase.setList(channelDtos);
        //查询total
        Integer channelCount = qihoOrderStrategyDAO.countByQuery(params);
        resultBase.setTotal(channelCount);
        return resultBase;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer updateStrategy(OrderStrategyDto orderStrategyDto) {
        return qihoOrderStrategyDAO.updateByEntity(orderStrategyDto);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer deleteStrategyById(Long id) {
        return qihoOrderStrategyDAO.deleteById(id);
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer insertStrategy(OrderStrategyDto orderStrategyDto) {
        Long result = qihoOrderStrategyDAO.insertStrategy(orderStrategyDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    @Override
    public Integer countStrategyByQuery(OrderStrategyParams params) {
        return qihoOrderStrategyDAO.countByQuery(params);
    }

    @Override
    public OrderStrategyDto findStrategyByStrategyType(StrategyType type) {
        QihoOrderStrategyEntity entity = qihoOrderStrategyDAO.findStrategyByStrategyType(type.getCode());
        if (null == entity)
            return null;
        return BeanUtils.copy(entity,OrderStrategyDto.class);
    }
}
