package com.qiho.center.biz.service.impl.order;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.params.OrderQueryParams;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelDecider;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderTaskService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.util.ShortUrlUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;

@Service
public class OrderTaskServiceImpl implements OrderTaskService {
	
	private  static Logger log = LoggerFactory.getLogger(OrderTaskServiceImpl.class);
	
	private  final static int PAGE_SIZE = 100;
	
	private  final static  SimpleDateFormat FORMAT = new SimpleDateFormat("MM月dd日HH时mm分");
	
	@Autowired
	private SmsService  smsService;
	@Autowired
	private  QihoOrderDAO  qihoOrderDAO;
	@Autowired
	private  QihoTemplateDAO qihoTemplateDAO;
	@Autowired
	private  FundOrderService  fundOrderService;
	@Autowired
	private	 OrderService  orderService;
	@Autowired
	private  PayChannelDecider  payChannelDecider;

	@Override
	public void remainOrderPay() {
		//查询状态为待付款状态下的订单总数
		OrderQueryParams params = new OrderQueryParams();
		params.setOrderStatus(OrderStatusEnum.TO_PAY.getCode());
		//将时间（秒）清零，防止出现秒级的时间误差
		params.setGmtCreateStart(DateUtils.addMinutes(DateUtils.setSeconds(new Date(), 0), -20));
		params.setGmtCreateEnd(DateUtils.addMinutes(DateUtils.setSeconds(new Date(), 0), -15));
       //查询短信模板
      	QihoTemplateEntity template = qihoTemplateDAO.findByCode(SmsTemplateEnum.PAY_REMIND.getCode());
       //分页处理相关数据
        int pageNum = 1;
      	while (true) {
        	params.setOffset((pageNum-1)*PAGE_SIZE);
        	params.setMax(PAGE_SIZE);
        	List<QihoOrderEntity> orderList = qihoOrderDAO.findOrderPageListByParams(params);
    		if(CollectionUtils.isEmpty(orderList)){
    			break;
    		}
    		//循环处理数据
    		for(QihoOrderEntity entity:orderList){
    			try{
    		        Map<String, String> context = Maps.newHashMap();
    		        context.put("payLimitTime",FORMAT.format(DateUtils.addMinutes(entity.getGmtCreate(),30)));
    		        context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId(entity.getOrderId()));
    		        String text = SimpleTemplateUtil.render(template.getTemplateContext(), context);
    				smsService.singleSend(text, entity.getMobile());
    			}catch(Exception e){
    				log.error("OrderTaskServiceImpl call remainOrderPay error, entity => {}",JSON.toJSONString(entity),e);
    			}
    		}
            pageNum++;
        }
	}

	@Override
	public void closeOverTimeOrder() {
		OrderQueryParams params = new OrderQueryParams();
		params.setOrderStatus(OrderStatusEnum.TO_PAY.getCode());
		params.setGmtCreateEnd(DateUtils.addHours(new Date(), -1));
		int pageNum = 1;
		while(true){
			params.setOffset((pageNum-1)*PAGE_SIZE);
        	params.setMax(PAGE_SIZE);
        	List<QihoOrderEntity> orderList = qihoOrderDAO.findOrderPageListByParams(params);
    		if(CollectionUtils.isEmpty(orderList)){
    			break;
    		}
    		for(QihoOrderEntity entity:orderList){
    			try{
    		       //查询一下订单的支付单信息
    				List<FundOrderDto> fundOrderList = fundOrderService.findByOrderIdAndBizType(entity.getOrderId(), FundBizTypeEnum.PAY.getCode());
    			   //如果没有查询到支付单的信息，则是数据不正常，可以直接关闭订单
    				if(CollectionUtils.isEmpty(fundOrderList)){
    					orderService.closeOrder(entity.getOrderId(), "付款失败",null); 
    					continue;
    				}
    			   //根据支付单信息确认是否已经处于支付中的状态
    				FundOrderDto fundOrder = fundOrderList.get(0);
    				PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(fundOrder.getPayType()));
    				PayDto result = payChannelProcessor.queryPayResult(entity.getOrderId());
    				//如果查询返回订单是支付成功的，应该属于消息未接收到，需要更新订单状态为付款成功
    				if(result.isSuccess()){
    					AsyncAcceptParams param = new AsyncAcceptParams();
    					param.setAccount(result.getPayerId());
    					param.setOrderId(entity.getOrderId());
    					param.setOutSqeNo(result.getOutTradeNo());
    					param.setReceiptAmount(result.getPayAmt());
    					payChannelProcessor.processNotify(param);
    				//关闭未支付的订单和其关联的支付单	
    				}else{
    					orderService.closeOrder(entity.getOrderId(), FundStatusEnum.FAILED.getDesc(),fundOrder.getFundId()); 
    				}
    			}catch(Exception e){
    				log.error("OrderTaskServiceImpl call remainOrderPay error, entity => {}",JSON.toJSONString(entity),e);
    			}
    		}
            pageNum++;
		}
	}

	@Override
	public void syncFundOrderStatus() {
        int pageNum = 1;
        FundPageParam param = new FundPageParam();
        param.setBizType(FundBizTypeEnum.REFUND.getCode());
        param.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        param.setMax(PAGE_SIZE);
        while (true) {
        	param.setOffset((pageNum-1)*PAGE_SIZE);
        	PagenationDto<FundOrderDto> pageResult = fundOrderService.queryFundPage(param);
            List<FundOrderDto> list = pageResult.getList();
        	if (CollectionUtils.isEmpty(list)) {
                break;
            }
        	for(FundOrderDto dto : list){
        		try{
        			if(Objects.equal(PayTypeEnum.getEnumByCode(dto.getPayType()), PayTypeEnum.COD)){
            			continue;
            		}
    				PayChannelProcessor payChannelProcessor = payChannelDecider.decidePayChannel(PayTypeEnum.getEnumByCode(dto.getPayType()));
    				RefundResult result = payChannelProcessor.refundQuery(dto.getOrderId(), dto.getFundId());
    				dto.setFundStatus(null!=result.getIsSuccess() && result.getIsSuccess() ? FundStatusEnum.SUCCESS.getCode() : FundStatusEnum.FAILED.getCode());
    				dto.setOutSeqNo(result.getOutTradeNo());
    				fundOrderService.update(dto);
        		}catch(Exception e){
        			log.error("OrderTaskServiceImpl call syncFundOrderStatus error, entity => {}",JSON.toJSONString(dto),e);
        		}
        	}
            pageNum++;
        }
	}
	
}
