package com.qiho.center.biz.service.impl.statistics;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.statistics.QueryStatisticsDayDto;
import com.qiho.center.api.dto.statistics.StatisticsDayDto;
import com.qiho.center.api.enums.QueryStatisticsDayTypeEnum;
import com.qiho.center.api.params.ExportStatisticsDayParams;
import com.qiho.center.biz.service.statistics.StatisticsDayService;
import com.qiho.center.common.dao.QihoStatisticsDayDAO;
import com.qiho.center.common.entity.statistics.StatisticsDayEntity;


@Service
public class StatisticsDayServiceImpl implements StatisticsDayService {

    @Autowired
    private QihoStatisticsDayDAO statisticsDayDAO;

    @Override
    public PagenationDto<StatisticsDayDto> queryStatisticsDayPage(QueryStatisticsDayDto queryDto, Integer pageNum,
                                                                  Integer pageSize) {
        PagenationDto<StatisticsDayDto> pagenation = new PagenationDto<>();
        StatisticsDayEntity entity = BeanUtils.copy(queryDto, StatisticsDayEntity.class);
        QueryStatisticsDayTypeEnum queryType = queryDto.getType();
        int total = 0;
        List<StatisticsDayEntity> list = null;
        switch (queryType) {
            case ITEAM_QUERY:
                total = statisticsDayDAO.countStatisticsByDate(entity);
                if (total > 0) {
                    list = statisticsDayDAO.queryStatisticsDayPage(entity, pageNum, pageSize);
                }
                break;
            case ADVERT_QUERY:
                total = statisticsDayDAO.countAdvertStatisticsByDateIteam(entity);
                if (total > 0) {
                    list = statisticsDayDAO.queryAdvertStatisticsDayPage(entity);
                    list.addAll(statisticsDayDAO.queryAdvertPackageStatisticsDayPage(entity));
                }
                break;
            case APP_QUERY:
                total = statisticsDayDAO.countAppStatisticsByDateIteam(entity);
                if (total > 0) {
                    list = statisticsDayDAO.queryAppStatisticsDayPage(entity, pageNum, pageSize);
                }
                break;
            case COUPON_NUM_QUERY:
                total = statisticsDayDAO.countCouponNumStatisticsByDateIteam(entity);
                if (total > 0) {
                    list = statisticsDayDAO.queryCouponNumStatisticsDayPage(entity);
                }
                break;
            default:
                return null;
        }

        pagenation.setList(BeanUtils.copyList(list, StatisticsDayDto.class));
        pagenation.setTotal(total);
        return pagenation;
    }

    @Override
    public Integer findAllStatisticsDayCount(ExportStatisticsDayParams params) {
        return statisticsDayDAO.findAllStatisticsDayCount(params);
    }

    @Override
    public List<StatisticsDayDto> queryAllStatisticsDay(ExportStatisticsDayParams params) {
        return BeanUtils.copyList(statisticsDayDAO.queryAllStatisticsDay(params), StatisticsDayDto.class);
    }

}
