package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.ERPClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2017/8/9.
 */
@Service
public class SyncStockBo {

    private static final Logger logger = LoggerFactory.getLogger(SyncStockBo.class);

    @Autowired
    private RemoteStockBackendService remoteStockBackendService;

    @Autowired
    private OrderStockService orderStockService;

    @Value("${qiho.erp.warehouse.no}")
    private String warehouseNo;

    private static final String pageSize = "100";

    @Value("${qiho.erp.stock.query.url}")
    private String erpStockQueryUrl;

    /***
     * 旺店通同步功能
     * 每个{}进行同步一次
     * {}可配置
     */
    public void syncStock(){
        int curPageNo = 0;
        List<UpdateStockReqDto> increaseStock = Lists.newArrayList();
        List<UpdateStockReqDto> descreaseStock = Lists.newArrayList();
        while(true){
            Map<String, String> params = getParams(curPageNo);
            String result = ERPClientUtil.execute(erpStockQueryUrl, params);
            JSONObject jsonObject = JSONObject.parseObject(result);
            String code = jsonObject.getString("code" );
            if(ErpErrorCodeReturnEnum.SUCCESS.getCode().equals(code)){
                result = jsonObject.getString("stocks" );
                List<ErpStock> stocks = JSONArray.parseArray(result,ErpStock.class);
                if(stocks.isEmpty()) break;
                orderStockService.handlerErpStocks(increaseStock, descreaseStock, stocks);
            }
            curPageNo ++;
        }
        DubboResult<Boolean> incResult = remoteStockBackendService.increaseItemStockBatch(increaseStock);
        DubboResult<Boolean> desResult = remoteStockBackendService.decreaseItemStockBatch(descreaseStock);
        if(!incResult.isSuccess()||!desResult.isSuccess()){
            logger.warn("库存同步失败：{},{}",incResult.getMsg(),desResult.getMsg());
        }
        logger.warn("库存同步:共{}页数据，每页100条",curPageNo);
    }


    /**
     * ERP查询库存参数
     * @param pageNo
     * @return
     */
    private Map<String,String> getParams(long pageNo) {
        Map<String, String> parmas = Maps.newHashMap();
        parmas.put("end_time", DateUtils.getSecondStr(new Date()));
        parmas.put("page_no",Long.toString(pageNo));
        parmas.put("page_size",pageSize);
        parmas.put("warehouse_no",warehouseNo);
        return parmas;
    }

}
