package com.qiho.center.biz.engine.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.FixedOrderComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;

/**
 * Created by danke on 2017/6/21.
 * 踢单辅助校验链路入口
 */
public class ShotOrderEngine extends BaseOrderEngine implements BaseEngine<OrderSnapshotDto> {

    Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 命中后执行处理器的map
     */
    private Map<String,BaseEngine> strategyTask;


    /**
     * 校验链路入口类
     * @param valuteData
     * @return
     */
    private BaseHandler baseHandler;


    @Override
    public OrderSnapshotDto process(OrderSnapshotDto valuteData) {
        if(null == valuteData)
            return valuteData;
        boolean isHit = false;
        try{
            //查询所有策略,循环校验
            List<OrderStrategyDto> orderStrategyDtos = getOrderStrategyList(StrategyType.SHOT_ORDER);
            //查询校验策略,如果为空,直接返回,
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                auditOrderPass(valuteData.getOrderId());
                return valuteData;
            }
            //进行一次基础的排序,优先处理审核拒绝的规则
            sortList(orderStrategyDtos);
            //循环执行校验策略
            for (OrderStrategyDto orderStrategyDto : orderStrategyDtos){
                Boolean flag = Boolean.TRUE;//用来标记返回值,falg决定后续对订单的处理
                ResultBase<List<StrategyRuleDto>> resultBase = validateorderStrategyDto(orderStrategyDto);
                if(!resultBase.hasSuccessValue()) {
                    logger.warn(resultBase.getErrorMsg());
                    continue;
                }
                List<StrategyRuleDto> strategyRuleDtos =resultBase.getValue();
                ProcessContext processContext = null;
                for (StrategyRuleDto strategyRuleDto : strategyRuleDtos){
                    //真正校验执行
                    processContext = ProcessFaceory.createProcessContext(valuteData,strategyRuleDto,orderStrategyDto);
                    ResultBase<Boolean> checkResult = baseHandler.handleRequest(processContext);
                    if (checkResult.hasSuccessValue()){
                        flag = flag && checkResult.getValue();
                    }else{
                        flag = Boolean.FALSE;
                        logger.warn("本条策略规则校验失败 msg={} strategyName={} ruleName={} fieldName={}",
                                checkResult.getErrorMsg(),orderStrategyDto.getStrategyName(),strategyRuleDto.getRuleName(),strategyRuleDto.getFieldName());
                        break;//跳出本策略的循环,其中一环错误,校验无意义
                    }
                }
                //命中后执行链路
                if(flag && null != strategyTask){
                    BaseEngine baseEngine = strategyTask.get(orderStrategyDto.getHandlerName());
                    if (null != baseEngine){
                        baseEngine.process(processContext);
                    }
                    isHit = true;
                    if(null!=processContext && processContext.getNeedBroken()){
                        break;
                    }
                }
            }
        }catch (Exception e){
            logger.error("策略过滤链路失败, data={}",valuteData.toString(), e);
        }
        //如果所有规则均为命中,则应该默认审核通过
        if(!isHit){
            auditOrderPass(valuteData.getOrderId());
        }
        return valuteData;
    }

    private void sortList(List<OrderStrategyDto> orderStrategyDtos) {
        String[] shotOrderHandler = { ShotOrderHandlerEnum.AUDIT_REJECT.getVal(),ShotOrderHandlerEnum.STAMP.getVal()};
        Comparator typeComparator = new FixedOrderComparator(shotOrderHandler);
        ComparatorChain moInfoComparator = new ComparatorChain();
        moInfoComparator.addComparator(new BeanComparator("handlerName",typeComparator));
        Collections.sort(orderStrategyDtos,moInfoComparator);
    }

    public BaseHandler getBaseHandler() {
        return baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public Map<String, BaseEngine> getStrategyTask() {
        return strategyTask;
    }

    public void setStrategyTask(Map<String, BaseEngine> strategyTask) {
        this.strategyTask = strategyTask;
    }

}
