package com.qiho.center.biz.engine.task;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.service.order.AnticheateService;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;

import javax.annotation.Resource;

/**
 * Created by danke on 2017/6/23.
 * 规则命中后对订单进行打标处理的task
 */
public class OrderStampTask implements BaseEngine<ProcessContext>{

    @Resource
    private AnticheateService anticheateService;

    @Override
    public ProcessContext process(ProcessContext processContext){
        if(null == processContext || null == processContext.getOrderSnapshotDto() || null == processContext.getStrategyDto()){
            //上线文为空,不做策略处理
            return processContext;
        }
        OrderSnapshotDto orderSnapshotDto = processContext.getOrderSnapshotDto();
        QihoAnticheateEntity qihoAnticheateEntity = new QihoAnticheateEntity();
        qihoAnticheateEntity.setOrderId(orderSnapshotDto.getOrderId());
        qihoAnticheateEntity.setRule(processContext.getStrategyDto().getStrategyName());
        anticheateService.insert(qihoAnticheateEntity);
        return processContext;
    }
}
