/**
 * Project Name:qiho-center-biz
 * File Name:AbstractQihoSimpleElasticJob.java
 * Package Name:com.qiho.center.biz.job
 * Date:2017年6月27日下午3:25:55
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.job;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import com.qiho.center.common.constant.Environment;
import com.qiho.center.common.util.AppLogUtil;


/**
 * ClassName:AbstractQihoSimpleElasticJob <br/>
 * Date:     2017年6月27日 下午3:25:55 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public abstract class AbstractQihoSimpleElasticJob extends AbstractSimpleElasticJob {

    private static Logger LOG = LoggerFactory.getLogger(AbstractQihoSimpleElasticJob.class);
    /**
     * @see com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob#process(com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext)
     */
    @Override
    public void process(JobExecutionMultipleShardingContext shardingContext) {
        if(Environment.isPrepub()){
            AppLogUtil.info(LOG, "预发环境不执行定时任务");
            return;
        }
        doProcess(shardingContext);
    }
    /**
     * @author zhanglihui
     * @param shardingContext
     */
    protected abstract void doProcess(JobExecutionMultipleShardingContext shardingContext);
}

