package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.SyncStockBo;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by weny.cai on 2017/8/9.
 */
@Component
public class StockSyncJob extends AbstractQihoSimpleElasticJob {

    private static final Logger logger  = LoggerFactory.getLogger(StockSyncJob.class);

    @Autowired
    SyncStockBo syncStockBo;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn(logger,"库存同步开始....");
        long startTime = System.currentTimeMillis();
        syncStockBo.syncStock();
        long endTime = System.currentTimeMillis();
        AppLogUtil.warn(logger,"同步结束...本次同步耗时{}",endTime-startTime);
    }

}
